/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.elasticsearch7.shaded.org.apache.logging.log4j.LogManager;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.IndicesOptions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.node.NodeClient;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.logging.DeprecationLogger;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.BaseRestHandler;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestChannel;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestController;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.action.RestToXContentListener;

public class RestGetIndicesAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(RestGetIndicesAction.class));
    public static final String TYPES_DEPRECATION_MESSAGE = "[types removal] Using `include_type_name` in get indices requests is deprecated. The parameter will be removed in the next major version.";
    private static final Set<String> allowedResponseParameters = Collections.unmodifiableSet(Stream.concat(Collections.singleton("include_type_name").stream(), Settings.FORMAT_PARAMS.stream()).collect(Collectors.toSet()));

    public RestGetIndicesAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/{index}", this);
        controller.registerHandler(RestRequest.Method.HEAD, "/{index}", this);
    }

    @Override
    public String getName() {
        return "get_indices_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        if (request.hasParam("include_type_name") && request.method().equals((Object)RestRequest.Method.GET)) {
            deprecationLogger.deprecatedAndMaybeLog("get_indices_with_types", TYPES_DEPRECATION_MESSAGE, new Object[0]);
        }
        GetIndexRequest getIndexRequest = new GetIndexRequest();
        getIndexRequest.indices(indices);
        getIndexRequest.indicesOptions(IndicesOptions.fromRequest(request, getIndexRequest.indicesOptions()));
        getIndexRequest.local(request.paramAsBoolean("local", getIndexRequest.local()));
        getIndexRequest.masterNodeTimeout(request.paramAsTime("master_timeout", getIndexRequest.masterNodeTimeout()));
        getIndexRequest.humanReadable(request.paramAsBoolean("human", false));
        getIndexRequest.includeDefaults(request.paramAsBoolean("include_defaults", false));
        return channel -> client.admin().indices().getIndex(getIndexRequest, new RestToXContentListener<GetIndexResponse>((RestChannel)channel));
    }

    @Override
    protected Set<String> responseParams() {
        return allowedResponseParameters;
    }
}

