/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.apache.logging.log4j.LogManager;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.IndicesOptions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.node.NodeClient;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.logging.DeprecationLogger;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.BaseRestHandler;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.BytesRestResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestController;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestStatus;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.action.RestBuilderListener;

public class RestGetFieldMappingAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(RestGetFieldMappingAction.class));
    public static final String TYPES_DEPRECATION_MESSAGE = "[types removal] Using include_type_name in get field mapping requests is deprecated. The parameter will be removed in the next major version.";

    public RestGetFieldMappingAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_mapping/field/{fields}", this);
        controller.registerHandler(RestRequest.Method.GET, "/_mapping/{type}/field/{fields}", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_mapping/field/{fields}", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/{type}/_mapping/field/{fields}", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_mapping/{type}/field/{fields}", this);
    }

    @Override
    public String getName() {
        return "get_field_mapping_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(final RestRequest request, NodeClient client) throws IOException {
        final String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        final String[] types = request.paramAsStringArrayOrEmptyIfAll("type");
        final String[] fields = Strings.splitStringByCommaToArray(request.param("fields"));
        boolean includeTypeName = request.paramAsBoolean("include_type_name", false);
        if (!includeTypeName && types.length > 0) {
            throw new IllegalArgumentException("Types cannot be specified unless include_type_name is set to true.");
        }
        if (request.hasParam("include_type_name")) {
            deprecationLogger.deprecatedAndMaybeLog("get_field_mapping_with_types", TYPES_DEPRECATION_MESSAGE, new Object[0]);
        }
        GetFieldMappingsRequest getMappingsRequest = new GetFieldMappingsRequest();
        getMappingsRequest.indices(indices).types(types).fields(fields).includeDefaults(request.paramAsBoolean("include_defaults", false));
        getMappingsRequest.indicesOptions(IndicesOptions.fromRequest(request, getMappingsRequest.indicesOptions()));
        getMappingsRequest.local(request.paramAsBoolean("local", getMappingsRequest.local()));
        return channel -> client.admin().indices().getFieldMappings(getMappingsRequest, (ActionListener<GetFieldMappingsResponse>)new RestBuilderListener<GetFieldMappingsResponse>(channel){

            @Override
            public RestResponse buildResponse(GetFieldMappingsResponse response, XContentBuilder builder) throws Exception {
                boolean isPossibleSingleFieldRequest;
                Map<String, Map<String, Map<String, GetFieldMappingsResponse.FieldMappingMetaData>>> mappingsByIndex = response.mappings();
                boolean bl = isPossibleSingleFieldRequest = indices.length == 1 && types.length == 1 && fields.length == 1;
                if (isPossibleSingleFieldRequest && RestGetFieldMappingAction.this.isFieldMappingMissingField(mappingsByIndex)) {
                    return new BytesRestResponse(RestStatus.OK, builder.startObject().endObject());
                }
                RestStatus status = RestStatus.OK;
                if (mappingsByIndex.isEmpty() && fields.length > 0) {
                    status = RestStatus.NOT_FOUND;
                }
                response.toXContent(builder, request);
                return new BytesRestResponse(status, builder);
            }
        });
    }

    private boolean isFieldMappingMissingField(Map<String, Map<String, Map<String, GetFieldMappingsResponse.FieldMappingMetaData>>> mappingsByIndex) {
        if (mappingsByIndex.size() != 1) {
            return false;
        }
        for (Map<String, Map<String, GetFieldMappingsResponse.FieldMappingMetaData>> value : mappingsByIndex.values()) {
            for (Map<String, GetFieldMappingsResponse.FieldMappingMetaData> fieldValue : value.values()) {
                for (Map.Entry<String, GetFieldMappingsResponse.FieldMappingMetaData> fieldMappingMetaDataEntry : fieldValue.entrySet()) {
                    if (!fieldMappingMetaDataEntry.getValue().isNull()) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

