/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.action.admin.cluster;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.cluster.node.reload.NodesReloadSecureSettingsRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.cluster.node.reload.NodesReloadSecureSettingsRequestBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.cluster.node.reload.NodesReloadSecureSettingsResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.node.NodeClient;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.BaseRestHandler;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.BytesRestResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestController;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestStatus;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.action.RestActions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.action.RestBuilderListener;

public final class RestReloadSecureSettingsAction
extends BaseRestHandler {
    public RestReloadSecureSettingsAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.POST, "/_nodes/reload_secure_settings", this);
        controller.registerHandler(RestRequest.Method.POST, "/_nodes/{nodeId}/reload_secure_settings", this);
    }

    @Override
    public String getName() {
        return "nodes_reload_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] nodesIds = Strings.splitStringByCommaToArray(request.param("nodeId"));
        NodesReloadSecureSettingsRequestBuilder nodesRequestBuilder = (NodesReloadSecureSettingsRequestBuilder)((NodesReloadSecureSettingsRequestBuilder)client.admin().cluster().prepareReloadSecureSettings().setTimeout(request.param("timeout"))).setNodesIds(nodesIds);
        NodesReloadSecureSettingsRequest nodesRequest = (NodesReloadSecureSettingsRequest)nodesRequestBuilder.request();
        return channel -> nodesRequestBuilder.execute(new RestBuilderListener<NodesReloadSecureSettingsResponse>(channel){

            @Override
            public RestResponse buildResponse(NodesReloadSecureSettingsResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                RestActions.buildNodesHeader(builder, this.channel.request(), response);
                builder.field("cluster_name", response.getClusterName().value());
                response.toXContent(builder, this.channel.request());
                builder.endObject();
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }

    @Override
    public boolean canTripCircuitBreaker() {
        return false;
    }
}

