/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.action;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.fieldcaps.FieldCapabilitiesRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.fieldcaps.FieldCapabilitiesResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.IndicesOptions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.node.NodeClient;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.BaseRestHandler;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestChannel;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestController;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.action.RestToXContentListener;

public class RestFieldCapabilitiesAction
extends BaseRestHandler {
    public RestFieldCapabilitiesAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_field_caps", this);
        controller.registerHandler(RestRequest.Method.POST, "/_field_caps", this);
        controller.registerHandler(RestRequest.Method.GET, "/{index}/_field_caps", this);
        controller.registerHandler(RestRequest.Method.POST, "/{index}/_field_caps", this);
    }

    @Override
    public String getName() {
        return "field_capabilities_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        FieldCapabilitiesRequest fieldRequest = new FieldCapabilitiesRequest().fields(Strings.splitStringByCommaToArray(request.param("fields"))).indices(indices);
        fieldRequest.indicesOptions(IndicesOptions.fromRequest(request, fieldRequest.indicesOptions()));
        fieldRequest.includeUnmapped(request.paramAsBoolean("include_unmapped", false));
        return channel -> client.fieldCaps(fieldRequest, new RestToXContentListener<FieldCapabilitiesResponse>((RestChannel)channel));
    }
}

