/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestHandler;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestRequest;

final class MethodHandlers {
    private final String path;
    private final Map<RestRequest.Method, RestHandler> methodHandlers;

    MethodHandlers(String path, RestHandler handler, RestRequest.Method ... methods) {
        this.path = path;
        this.methodHandlers = new HashMap<RestRequest.Method, RestHandler>(methods.length);
        for (RestRequest.Method method : methods) {
            this.methodHandlers.put(method, handler);
        }
    }

    public MethodHandlers addMethod(RestRequest.Method method, RestHandler handler) {
        RestHandler existing = this.methodHandlers.putIfAbsent(method, handler);
        if (existing != null) {
            throw new IllegalArgumentException("Cannot replace existing handler for [" + this.path + "] for method: " + (Object)((Object)method));
        }
        return this;
    }

    public MethodHandlers addMethods(RestHandler handler, RestRequest.Method ... methods) {
        for (RestRequest.Method method : methods) {
            this.addMethod(method, handler);
        }
        return this;
    }

    public Optional<RestHandler> getHandler(RestRequest.Method method) {
        return Optional.ofNullable(this.methodHandlers.get((Object)method));
    }

    public Set<RestRequest.Method> getValidMethods() {
        return this.methodHandlers.keySet();
    }
}

