/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.repositories;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexCommit;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.IndexMetaData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.MetaData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.RepositoryMetaData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.node.DiscoveryNode;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.component.LifecycleComponent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MapperService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.shard.IndexShard;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.shard.ShardId;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.snapshots.IndexShardSnapshotStatus;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.store.Store;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.indices.recovery.RecoveryState;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.repositories.IndexId;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.repositories.RepositoryData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.snapshots.SnapshotId;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.snapshots.SnapshotInfo;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.snapshots.SnapshotShardFailure;

public interface Repository
extends LifecycleComponent {
    public RepositoryMetaData getMetadata();

    public SnapshotInfo getSnapshotInfo(SnapshotId var1);

    public MetaData getSnapshotGlobalMetaData(SnapshotId var1);

    public IndexMetaData getSnapshotIndexMetaData(SnapshotId var1, IndexId var2) throws IOException;

    public RepositoryData getRepositoryData();

    public void initializeSnapshot(SnapshotId var1, List<IndexId> var2, MetaData var3);

    public SnapshotInfo finalizeSnapshot(SnapshotId var1, List<IndexId> var2, long var3, String var5, int var6, List<SnapshotShardFailure> var7, long var8, boolean var10, Map<String, Object> var11);

    public void deleteSnapshot(SnapshotId var1, long var2, ActionListener<Void> var4);

    public long getSnapshotThrottleTimeInNanos();

    public long getRestoreThrottleTimeInNanos();

    public String startVerification();

    public void endVerification(String var1);

    public void verify(String var1, DiscoveryNode var2);

    public boolean isReadOnly();

    @Deprecated
    default public void snapshotShard(IndexShard indexShard, SnapshotId snapshotId, IndexId indexId, IndexCommit snapshotIndexCommit, IndexShardSnapshotStatus snapshotStatus) {
        this.snapshotShard(indexShard.store(), indexShard.mapperService(), snapshotId, indexId, snapshotIndexCommit, snapshotStatus);
    }

    public void snapshotShard(Store var1, MapperService var2, SnapshotId var3, IndexId var4, IndexCommit var5, IndexShardSnapshotStatus var6);

    @Deprecated
    default public void restoreShard(IndexShard shard, Store store, SnapshotId snapshotId, Version version, IndexId indexId, ShardId snapshotShardId, RecoveryState recoveryState) {
        this.restoreShard(store, snapshotId, version, indexId, snapshotShardId, recoveryState);
    }

    public void restoreShard(Store var1, SnapshotId var2, Version var3, IndexId var4, ShardId var5, RecoveryState var6);

    public IndexShardSnapshotStatus getShardSnapshotStatus(SnapshotId var1, Version var2, IndexId var3, ShardId var4);

    public static interface Factory {
        public Repository create(RepositoryMetaData var1) throws Exception;

        default public Repository create(RepositoryMetaData metaData, Function<String, Factory> typeLookup) throws Exception {
            return this.create(metaData);
        }
    }
}

