/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.node;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Build;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.cluster.node.info.NodeInfo;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.stats.CommonStatsFlags;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.search.SearchTransportService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.service.ClusterService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.SettingsFilter;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.core.internal.io.IOUtils;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.discovery.Discovery;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.http.HttpServerTransport;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.indices.IndicesService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ingest.IngestService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.monitor.MonitorService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.node.ResponseCollectorService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.plugins.PluginsService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.script.ScriptService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.threadpool.ThreadPool;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportService;

public class NodeService
implements Closeable {
    private final Settings settings;
    private final ThreadPool threadPool;
    private final MonitorService monitorService;
    private final TransportService transportService;
    private final IndicesService indicesService;
    private final PluginsService pluginService;
    private final CircuitBreakerService circuitBreakerService;
    private final IngestService ingestService;
    private final SettingsFilter settingsFilter;
    private final ScriptService scriptService;
    private final HttpServerTransport httpServerTransport;
    private final ResponseCollectorService responseCollectorService;
    private final SearchTransportService searchTransportService;
    private final Discovery discovery;

    NodeService(Settings settings, ThreadPool threadPool, MonitorService monitorService, Discovery discovery, TransportService transportService, IndicesService indicesService, PluginsService pluginService, CircuitBreakerService circuitBreakerService, ScriptService scriptService, @Nullable HttpServerTransport httpServerTransport, IngestService ingestService, ClusterService clusterService, SettingsFilter settingsFilter, ResponseCollectorService responseCollectorService, SearchTransportService searchTransportService) {
        this.settings = settings;
        this.threadPool = threadPool;
        this.monitorService = monitorService;
        this.transportService = transportService;
        this.indicesService = indicesService;
        this.discovery = discovery;
        this.pluginService = pluginService;
        this.circuitBreakerService = circuitBreakerService;
        this.httpServerTransport = httpServerTransport;
        this.ingestService = ingestService;
        this.settingsFilter = settingsFilter;
        this.scriptService = scriptService;
        this.responseCollectorService = responseCollectorService;
        this.searchTransportService = searchTransportService;
        clusterService.addStateApplier(ingestService);
    }

    public NodeInfo info(boolean settings, boolean os, boolean process, boolean jvm, boolean threadPool, boolean transport, boolean http, boolean plugin, boolean ingest, boolean indices) {
        return new NodeInfo(Version.CURRENT, Build.CURRENT, this.transportService.getLocalNode(), settings ? this.settingsFilter.filter(this.settings) : null, os ? this.monitorService.osService().info() : null, process ? this.monitorService.processService().info() : null, jvm ? this.monitorService.jvmService().info() : null, threadPool ? this.threadPool.info() : null, transport ? this.transportService.info() : null, http ? (this.httpServerTransport == null ? null : this.httpServerTransport.info()) : null, plugin ? (this.pluginService == null ? null : this.pluginService.info()) : null, ingest ? (this.ingestService == null ? null : this.ingestService.info()) : null, indices ? this.indicesService.getTotalIndexingBufferBytes() : null);
    }

    public NodeStats stats(CommonStatsFlags indices, boolean os, boolean process, boolean jvm, boolean threadPool, boolean fs, boolean transport, boolean http, boolean circuitBreaker, boolean script, boolean discoveryStats, boolean ingest, boolean adaptiveSelection) {
        return new NodeStats(this.transportService.getLocalNode(), System.currentTimeMillis(), indices.anySet() ? this.indicesService.stats(true, indices) : null, os ? this.monitorService.osService().stats() : null, process ? this.monitorService.processService().stats() : null, jvm ? this.monitorService.jvmService().stats() : null, threadPool ? this.threadPool.stats() : null, fs ? this.monitorService.fsService().stats() : null, transport ? this.transportService.stats() : null, http ? (this.httpServerTransport == null ? null : this.httpServerTransport.stats()) : null, circuitBreaker ? this.circuitBreakerService.stats() : null, script ? this.scriptService.stats() : null, discoveryStats ? this.discovery.stats() : null, ingest ? this.ingestService.stats() : null, adaptiveSelection ? this.responseCollectorService.getAdaptiveStats(this.searchTransportService.getPendingSearchRequests()) : null);
    }

    public IngestService getIngestService() {
        return this.ingestService;
    }

    public MonitorService getMonitorService() {
        return this.monitorService;
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(new Closeable[]{this.indicesService});
    }

    public boolean awaitClose(long timeout, TimeUnit timeUnit) throws InterruptedException {
        return this.indicesService.awaitClose(timeout, timeUnit);
    }
}

