/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.indices.recovery;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import java.util.stream.StreamSupport;
import org.apache.flink.elasticsearch7.shaded.org.apache.logging.log4j.Logger;
import org.apache.flink.elasticsearch7.shaded.org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.CorruptIndexException;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexCommit;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.IOContext;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.IndexInput;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.ArrayUtil;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ElasticsearchException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ExceptionsHelper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.StepListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.ShardRouting;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.CheckedSupplier;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.StopWatch;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.bytes.BytesArray;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.collect.Tuple;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lease.Releasable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lease.Releasables;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.logging.Loggers;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lucene.store.InputStreamIndexInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.unit.ByteSizeValue;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.unit.TimeValue;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.CancellableThreads;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.concurrent.FutureUtils;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.core.internal.io.IOUtils;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.engine.Engine;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.engine.RecoveryEngineException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.seqno.LocalCheckpointTracker;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.seqno.RetentionLeases;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.seqno.SequenceNumbers;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.shard.IndexShard;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.shard.IndexShardClosedException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.shard.IndexShardRelocatedException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.shard.IndexShardState;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.store.Store;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.store.StoreFileMetaData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.translog.Translog;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.indices.recovery.DelayRecoveryException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.indices.recovery.RecoverFilesRecoveryException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.indices.recovery.RecoveryResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.indices.recovery.RecoveryTargetHandler;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.indices.recovery.StartRecoveryRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.threadpool.ThreadPool;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.RemoteTransportException;

public class RecoverySourceHandler {
    protected final Logger logger;
    private final IndexShard shard;
    private final int shardId;
    private final StartRecoveryRequest request;
    private final int chunkSizeInBytes;
    private final RecoveryTargetHandler recoveryTarget;
    private final int maxConcurrentFileChunks;
    private final CancellableThreads cancellableThreads = new CancellableThreads();

    public RecoverySourceHandler(IndexShard shard, RecoveryTargetHandler recoveryTarget, StartRecoveryRequest request, int fileChunkSizeInBytes, int maxConcurrentFileChunks) {
        this.shard = shard;
        this.recoveryTarget = recoveryTarget;
        this.request = request;
        this.shardId = this.request.shardId().id();
        this.logger = Loggers.getLogger(this.getClass(), request.shardId(), "recover to " + request.targetNode().getName());
        this.chunkSizeInBytes = fileChunkSizeInBytes;
        this.maxConcurrentFileChunks = request.targetNode().getVersion().onOrAfter(Version.V_6_7_0) ? maxConcurrentFileChunks : 1;
    }

    public StartRecoveryRequest getRequest() {
        return this.request;
    }

    public void recoverToTarget(ActionListener<RecoveryResponse> listener) {
        CopyOnWriteArrayList<Closeable> resources = new CopyOnWriteArrayList<Closeable>();
        Closeable releaseResources = () -> IOUtils.close(resources);
        ActionListener<RecoveryResponse> wrappedListener = ActionListener.notifyOnce(listener);
        try {
            long startingSeqNo;
            this.cancellableThreads.setOnCancel((reason, beforeCancelEx) -> {
                ElasticsearchException e = this.shard.state() == IndexShardState.CLOSED ? new IndexShardClosedException(this.shard.shardId(), "shard is closed and recovery was canceled reason [" + reason + "]") : new CancellableThreads.ExecutionCancelledException("recovery was canceled reason [" + reason + "]");
                if (beforeCancelEx != null) {
                    e.addSuppressed(beforeCancelEx);
                }
                IOUtils.closeWhileHandlingException(releaseResources, () -> wrappedListener.onFailure(e));
                throw e;
            });
            Consumer<Exception> onFailure = e -> IOUtils.closeWhileHandlingException(releaseResources, () -> wrappedListener.onFailure((Exception)e));
            RecoverySourceHandler.runUnderPrimaryPermit(() -> {
                IndexShardRoutingTable routingTable = this.shard.getReplicationGroup().getRoutingTable();
                ShardRouting targetShardRouting = routingTable.getByAllocationId(this.request.targetAllocationId());
                if (targetShardRouting == null) {
                    this.logger.debug("delaying recovery of {} as it is not listed as assigned to target node {}", (Object)this.request.shardId(), (Object)this.request.targetNode());
                    throw new DelayRecoveryException("source node does not have the shard listed in its state as allocated on the node");
                }
                assert (targetShardRouting.initializing()) : "expected recovery target to be initializing but was " + targetShardRouting;
            }, this.shardId + " validating recovery target [" + this.request.targetAllocationId() + "] registered ", this.shard, this.cancellableThreads, this.logger);
            Closeable retentionLock = this.shard.acquireRetentionLock();
            resources.add(retentionLock);
            boolean isSequenceNumberBasedRecovery = this.request.startingSeqNo() != -2L && this.isTargetSameHistory() && this.shard.hasCompleteHistoryOperations("peer-recovery", this.request.startingSeqNo());
            StepListener<SendFileResult> sendFileStep = new StepListener<SendFileResult>();
            StepListener<TimeValue> prepareEngineStep = new StepListener<TimeValue>();
            StepListener<SendSnapshotResult> sendSnapshotStep = new StepListener<SendSnapshotResult>();
            StepListener<Void> finalizeStep = new StepListener<Void>();
            if (isSequenceNumberBasedRecovery) {
                this.logger.trace("performing sequence numbers based recovery. starting at [{}]", (Object)this.request.startingSeqNo());
                startingSeqNo = this.request.startingSeqNo();
                sendFileStep.onResponse(SendFileResult.EMPTY);
            } else {
                Engine.IndexCommitRef safeCommitRef;
                try {
                    safeCommitRef = this.shard.acquireSafeIndexCommit();
                    resources.add(safeCommitRef);
                }
                catch (Exception e2) {
                    throw new RecoveryEngineException(this.shard.shardId(), 1, "snapshot failed", e2);
                }
                startingSeqNo = 0L;
                try {
                    int estimateNumOps = this.shard.estimateNumberOfHistoryOperations("peer-recovery", startingSeqNo);
                    this.shard.store().incRef();
                    Releasable[] releasableArray = new Releasable[1];
                    releasableArray[0] = this.shard.store()::decRef;
                    Releasable releaseStore = Releasables.releaseOnce(releasableArray);
                    resources.add(releaseStore);
                    sendFileStep.whenComplete(r -> IOUtils.close(safeCommitRef, releaseStore), e -> {
                        try {
                            IOUtils.close(safeCommitRef, releaseStore);
                        }
                        catch (IOException ex) {
                            this.logger.warn("releasing snapshot caused exception", (Throwable)ex);
                        }
                    });
                    this.phase1(safeCommitRef.getIndexCommit(), this.shard.getLastKnownGlobalCheckpoint(), () -> estimateNumOps, sendFileStep);
                }
                catch (Exception e3) {
                    throw new RecoveryEngineException(this.shard.shardId(), 1, "sendFileStep failed", e3);
                }
            }
            assert (startingSeqNo >= 0L) : "startingSeqNo must be non negative. got: " + startingSeqNo;
            sendFileStep.whenComplete(r -> this.prepareTargetForTranslog(!isSequenceNumberBasedRecovery, this.shard.estimateNumberOfHistoryOperations("peer-recovery", startingSeqNo), prepareEngineStep), onFailure);
            prepareEngineStep.whenComplete(prepareEngineTime -> {
                RecoverySourceHandler.runUnderPrimaryPermit(() -> this.shard.initiateTracking(this.request.targetAllocationId()), this.shardId + " initiating tracking of " + this.request.targetAllocationId(), this.shard, this.cancellableThreads, this.logger);
                long endingSeqNo = this.shard.seqNoStats().getMaxSeqNo();
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("snapshot translog for recovery; current size is [{}]", (Object)this.shard.estimateNumberOfHistoryOperations("peer-recovery", startingSeqNo));
                }
                Translog.Snapshot phase2Snapshot = this.shard.getHistoryOperations("peer-recovery", startingSeqNo);
                resources.add(phase2Snapshot);
                retentionLock.close();
                long maxSeenAutoIdTimestamp = this.shard.getMaxSeenAutoIdTimestamp();
                long maxSeqNoOfUpdatesOrDeletes = this.shard.getMaxSeqNoOfUpdatesOrDeletes();
                RetentionLeases retentionLeases = this.shard.getRetentionLeases();
                long mappingVersionOnPrimary = this.shard.indexSettings().getIndexMetaData().getMappingVersion();
                this.phase2(startingSeqNo, endingSeqNo, phase2Snapshot, maxSeenAutoIdTimestamp, maxSeqNoOfUpdatesOrDeletes, retentionLeases, mappingVersionOnPrimary, sendSnapshotStep);
                sendSnapshotStep.whenComplete(r -> IOUtils.close(phase2Snapshot), e -> {
                    IOUtils.closeWhileHandlingException(phase2Snapshot);
                    onFailure.accept(new RecoveryEngineException(this.shard.shardId(), 2, "phase2 failed", (Throwable)e));
                });
            }, onFailure);
            sendSnapshotStep.whenComplete(r -> this.finalizeRecovery(r.targetLocalCheckpoint, finalizeStep), onFailure);
            finalizeStep.whenComplete(r -> {
                long phase1ThrottlingWaitTime = 0L;
                SendSnapshotResult sendSnapshotResult = (SendSnapshotResult)sendSnapshotStep.result();
                SendFileResult sendFileResult = (SendFileResult)sendFileStep.result();
                RecoveryResponse response = new RecoveryResponse(sendFileResult.phase1FileNames, sendFileResult.phase1FileSizes, sendFileResult.phase1ExistingFileNames, sendFileResult.phase1ExistingFileSizes, sendFileResult.totalSize, sendFileResult.existingTotalSize, sendFileResult.took.millis(), 0L, ((TimeValue)prepareEngineStep.result()).millis(), sendSnapshotResult.totalOperations, sendSnapshotResult.tookTime.millis());
                try {
                    wrappedListener.onResponse(response);
                }
                finally {
                    IOUtils.close(resources);
                }
            }, onFailure);
        }
        catch (Exception e4) {
            IOUtils.closeWhileHandlingException(releaseResources, () -> wrappedListener.onFailure(e4));
        }
    }

    private boolean isTargetSameHistory() {
        String targetHistoryUUID = this.request.metadataSnapshot().getHistoryUUID();
        assert (targetHistoryUUID != null || this.shard.indexSettings().getIndexVersionCreated().before(Version.V_6_0_0_rc1)) : "incoming target history N/A but index was created after or on 6.0.0-rc1";
        return targetHistoryUUID != null && targetHistoryUUID.equals(this.shard.getHistoryUUID());
    }

    static void runUnderPrimaryPermit(CancellableThreads.Interruptible runnable, String reason, IndexShard primary, CancellableThreads cancellableThreads, Logger logger) {
        cancellableThreads.execute(() -> {
            final CompletableFuture permit = new CompletableFuture();
            ActionListener<Releasable> onAcquired = new ActionListener<Releasable>(){

                @Override
                public void onResponse(Releasable releasable) {
                    if (!permit.complete(releasable)) {
                        releasable.close();
                    }
                }

                @Override
                public void onFailure(Exception e) {
                    permit.completeExceptionally(e);
                }
            };
            primary.acquirePrimaryOperationPermit(onAcquired, "same", reason);
            try (Releasable ignored = (Releasable)FutureUtils.get(permit);){
                if (primary.isRelocatedPrimary()) {
                    throw new IndexShardRelocatedException(primary.shardId());
                }
                runnable.run();
            }
            finally {
                permit.whenComplete((r, e) -> {
                    if (r != null) {
                        r.close();
                    }
                    if (e != null) {
                        logger.trace("suppressing exception on completion (it was already bubbled up or the operation was aborted)", (Throwable)e);
                    }
                });
            }
        });
    }

    void phase1(IndexCommit snapshot, long globalCheckpoint, IntSupplier translogOps, ActionListener<SendFileResult> listener) {
        this.cancellableThreads.checkForCancel();
        long totalSizeInBytes = 0L;
        long existingTotalSizeInBytes = 0L;
        ArrayList<String> phase1FileNames = new ArrayList<String>();
        ArrayList<Long> phase1FileSizes = new ArrayList<Long>();
        ArrayList<String> phase1ExistingFileNames = new ArrayList<String>();
        ArrayList<Long> phase1ExistingFileSizes = new ArrayList<Long>();
        Store store = this.shard.store();
        try {
            Store.MetadataSnapshot recoverySourceMetadata;
            StopWatch stopWatch = new StopWatch().start();
            try {
                recoverySourceMetadata = store.getMetadata(snapshot);
            }
            catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException ex) {
                this.shard.failShard("recovery", ex);
                throw ex;
            }
            for (String string : snapshot.getFileNames()) {
                StoreFileMetaData storeFileMetaData = recoverySourceMetadata.get(string);
                if (storeFileMetaData != null) continue;
                this.logger.info("Snapshot differs from actual index for file: {} meta: {}", (Object)string, (Object)recoverySourceMetadata.asMap());
                throw new CorruptIndexException("Snapshot differs from actual index - maybe index was removed metadata has " + recoverySourceMetadata.asMap().size() + " files", string);
            }
            if (!this.canSkipPhase1(recoverySourceMetadata, this.request.metadataSnapshot())) {
                Store.RecoveryDiff diff = recoverySourceMetadata.recoveryDiff(this.request.metadataSnapshot());
                for (StoreFileMetaData storeFileMetaData : diff.identical) {
                    phase1ExistingFileNames.add(storeFileMetaData.name());
                    phase1ExistingFileSizes.add(storeFileMetaData.length());
                    existingTotalSizeInBytes += storeFileMetaData.length();
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace("recovery [phase1]: not recovering [{}], exist in local store and has checksum [{}], size [{}]", (Object)storeFileMetaData.name(), (Object)storeFileMetaData.checksum(), (Object)storeFileMetaData.length());
                    }
                    totalSizeInBytes += storeFileMetaData.length();
                }
                ArrayList<StoreFileMetaData> arrayList = new ArrayList<StoreFileMetaData>(diff.different.size() + diff.missing.size());
                arrayList.addAll(diff.different);
                arrayList.addAll(diff.missing);
                for (StoreFileMetaData md : arrayList) {
                    if (this.request.metadataSnapshot().asMap().containsKey(md.name())) {
                        this.logger.trace("recovery [phase1]: recovering [{}], exists in local store, but is different: remote [{}], local [{}]", (Object)md.name(), (Object)this.request.metadataSnapshot().asMap().get(md.name()), (Object)md);
                    } else {
                        this.logger.trace("recovery [phase1]: recovering [{}], does not exist in remote", (Object)md.name());
                    }
                    phase1FileNames.add(md.name());
                    phase1FileSizes.add(md.length());
                    totalSizeInBytes += md.length();
                }
                this.logger.trace("recovery [phase1]: recovering_files [{}] with total_size [{}], reusing_files [{}] with total_size [{}]", (Object)phase1FileNames.size(), (Object)new ByteSizeValue(totalSizeInBytes), (Object)phase1ExistingFileNames.size(), (Object)new ByteSizeValue(existingTotalSizeInBytes));
                StepListener<Void> stepListener = new StepListener<Void>();
                StepListener<Void> cleanFilesStep = new StepListener<Void>();
                this.cancellableThreads.execute(() -> this.recoveryTarget.receiveFileInfo(phase1FileNames, phase1FileSizes, phase1ExistingFileNames, phase1ExistingFileSizes, translogOps.getAsInt(), sendFileInfoStep));
                stepListener.whenComplete(r -> {
                    this.sendFiles(store, phase1Files.toArray(new StoreFileMetaData[0]), translogOps);
                    this.cleanFiles(store, recoverySourceMetadata, translogOps, globalCheckpoint, cleanFilesStep);
                }, listener::onFailure);
                long totalSize = totalSizeInBytes;
                long existingTotalSize = existingTotalSizeInBytes;
                cleanFilesStep.whenComplete(r -> {
                    TimeValue took = stopWatch.totalTime();
                    this.logger.trace("recovery [phase1]: took [{}]", (Object)took);
                    listener.onResponse(new SendFileResult(phase1FileNames, phase1FileSizes, totalSize, phase1ExistingFileNames, phase1ExistingFileSizes, existingTotalSize, took));
                }, listener::onFailure);
            } else {
                this.logger.trace("skipping [phase1]- identical sync id [{}] found on both source and target", (Object)recoverySourceMetadata.getSyncId());
                TimeValue took = stopWatch.totalTime();
                this.logger.trace("recovery [phase1]: took [{}]", (Object)took);
                listener.onResponse(new SendFileResult(phase1FileNames, phase1FileSizes, totalSizeInBytes, phase1ExistingFileNames, phase1ExistingFileSizes, existingTotalSizeInBytes, took));
            }
        }
        catch (Exception e) {
            throw new RecoverFilesRecoveryException(this.request.shardId(), phase1FileNames.size(), new ByteSizeValue(totalSizeInBytes), e);
        }
    }

    boolean canSkipPhase1(Store.MetadataSnapshot source, Store.MetadataSnapshot target) {
        if (source.getSyncId() == null || !source.getSyncId().equals(target.getSyncId())) {
            return false;
        }
        if (source.getNumDocs() != target.getNumDocs()) {
            throw new IllegalStateException("try to recover " + this.request.shardId() + " from primary shard with sync id but number of docs differ: " + source.getNumDocs() + " (" + this.request.sourceNode().getName() + ", primary) vs " + target.getNumDocs() + "(" + this.request.targetNode().getName() + ")");
        }
        SequenceNumbers.CommitInfo sourceSeqNos = SequenceNumbers.loadSeqNoInfoFromLuceneCommit(source.getCommitUserData().entrySet());
        SequenceNumbers.CommitInfo targetSeqNos = SequenceNumbers.loadSeqNoInfoFromLuceneCommit(target.getCommitUserData().entrySet());
        if (sourceSeqNos.localCheckpoint != targetSeqNos.localCheckpoint || targetSeqNos.maxSeqNo != sourceSeqNos.maxSeqNo) {
            String message = "try to recover " + this.request.shardId() + " with sync id but seq_no stats are mismatched: [" + source.getCommitUserData() + "] vs [" + target.getCommitUserData() + "]";
            assert (false) : message;
            throw new IllegalStateException(message);
        }
        return true;
    }

    void prepareTargetForTranslog(boolean fileBasedRecovery, int totalTranslogOps, ActionListener<TimeValue> listener) {
        StopWatch stopWatch = new StopWatch().start();
        ActionListener<Void> wrappedListener = ActionListener.wrap(nullVal -> {
            stopWatch.stop();
            TimeValue tookTime = stopWatch.totalTime();
            this.logger.trace("recovery [phase1]: remote engine start took [{}]", (Object)tookTime);
            listener.onResponse(tookTime);
        }, e -> listener.onFailure(new RecoveryEngineException(this.shard.shardId(), 1, "prepare target for translog failed", (Throwable)e)));
        this.logger.trace("recovery [phase1]: prepare remote engine for translog");
        this.cancellableThreads.execute(() -> this.recoveryTarget.prepareForTranslogOperations(fileBasedRecovery, totalTranslogOps, wrappedListener));
    }

    void phase2(long startingSeqNo, long endingSeqNo, Translog.Snapshot snapshot, long maxSeenAutoIdTimestamp, long maxSeqNoOfUpdatesOrDeletes, RetentionLeases retentionLeases, long mappingVersion, ActionListener<SendSnapshotResult> listener) throws IOException {
        if (this.shard.state() == IndexShardState.CLOSED) {
            throw new IndexShardClosedException(this.request.shardId());
        }
        this.logger.trace("recovery [phase2]: sending transaction log operations (from [" + startingSeqNo + "] to [" + endingSeqNo + "]");
        AtomicInteger skippedOps = new AtomicInteger();
        AtomicInteger totalSentOps = new AtomicInteger();
        AtomicInteger lastBatchCount = new AtomicInteger();
        CheckedSupplier<List<Translog.Operation>, IOException> readNextBatch = () -> {
            Translog.Snapshot snapshot2 = snapshot;
            synchronized (snapshot2) {
                Translog.Operation operation;
                ArrayList<Translog.Operation> ops = lastBatchCount.get() > 0 ? new ArrayList<Translog.Operation>(lastBatchCount.get()) : new ArrayList();
                long batchSizeInBytes = 0L;
                while ((operation = snapshot.next()) != null) {
                    if (this.shard.state() == IndexShardState.CLOSED) {
                        throw new IndexShardClosedException(this.request.shardId());
                    }
                    this.cancellableThreads.checkForCancel();
                    long seqNo = operation.seqNo();
                    if (seqNo < startingSeqNo || seqNo > endingSeqNo) {
                        skippedOps.incrementAndGet();
                        continue;
                    }
                    ops.add(operation);
                    totalSentOps.incrementAndGet();
                    if ((batchSizeInBytes += operation.estimateSize()) < (long)this.chunkSizeInBytes) continue;
                    break;
                }
                lastBatchCount.set(ops.size());
                return ops;
            }
        };
        StopWatch stopWatch = new StopWatch().start();
        ActionListener<Long> batchedListener = ActionListener.map(listener, targetLocalCheckpoint -> {
            assert (snapshot.totalOperations() == snapshot.skippedOperations() + skippedOps.get() + totalSentOps.get()) : String.format(Locale.ROOT, "expected total [%d], overridden [%d], skipped [%d], total sent [%d]", snapshot.totalOperations(), snapshot.skippedOperations(), skippedOps.get(), totalSentOps.get());
            stopWatch.stop();
            TimeValue tookTime = stopWatch.totalTime();
            this.logger.trace("recovery [phase2]: took [{}]", (Object)tookTime);
            return new SendSnapshotResult((long)targetLocalCheckpoint, totalSentOps.get(), tookTime);
        });
        this.sendBatch(readNextBatch, true, -2L, snapshot.totalOperations(), maxSeenAutoIdTimestamp, maxSeqNoOfUpdatesOrDeletes, retentionLeases, mappingVersion, batchedListener);
    }

    private void sendBatch(CheckedSupplier<List<Translog.Operation>, IOException> nextBatch, boolean firstBatch, long targetLocalCheckpoint, int totalTranslogOps, long maxSeenAutoIdTimestamp, long maxSeqNoOfUpdatesOrDeletes, RetentionLeases retentionLeases, long mappingVersionOnPrimary, ActionListener<Long> listener) throws IOException {
        assert (ThreadPool.assertCurrentMethodIsNotCalledRecursively());
        List<Translog.Operation> operations = nextBatch.get();
        if (!operations.isEmpty() || firstBatch) {
            this.cancellableThreads.execute(() -> this.recoveryTarget.indexTranslogOperations(operations, totalTranslogOps, maxSeenAutoIdTimestamp, maxSeqNoOfUpdatesOrDeletes, retentionLeases, mappingVersionOnPrimary, ActionListener.wrap(newCheckpoint -> this.sendBatch(nextBatch, false, SequenceNumbers.max(targetLocalCheckpoint, newCheckpoint), totalTranslogOps, maxSeenAutoIdTimestamp, maxSeqNoOfUpdatesOrDeletes, retentionLeases, mappingVersionOnPrimary, listener), listener::onFailure)));
        } else {
            listener.onResponse(targetLocalCheckpoint);
        }
    }

    void finalizeRecovery(long targetLocalCheckpoint, ActionListener<Void> listener) throws IOException {
        if (this.shard.state() == IndexShardState.CLOSED) {
            throw new IndexShardClosedException(this.request.shardId());
        }
        this.cancellableThreads.checkForCancel();
        StopWatch stopWatch = new StopWatch().start();
        this.logger.trace("finalizing recovery");
        RecoverySourceHandler.runUnderPrimaryPermit(() -> this.shard.markAllocationIdAsInSync(this.request.targetAllocationId(), targetLocalCheckpoint), this.shardId + " marking " + this.request.targetAllocationId() + " as in sync", this.shard, this.cancellableThreads, this.logger);
        long globalCheckpoint = this.shard.getLastKnownGlobalCheckpoint();
        StepListener<Void> finalizeListener = new StepListener<Void>();
        this.cancellableThreads.executeIO(() -> this.recoveryTarget.finalizeRecovery(globalCheckpoint, finalizeListener));
        finalizeListener.whenComplete(r -> {
            RecoverySourceHandler.runUnderPrimaryPermit(() -> this.shard.updateGlobalCheckpointForShard(this.request.targetAllocationId(), globalCheckpoint), this.shardId + " updating " + this.request.targetAllocationId() + "'s global checkpoint", this.shard, this.cancellableThreads, this.logger);
            if (this.request.isPrimaryRelocation()) {
                this.logger.trace("performing relocation hand-off");
                this.cancellableThreads.execute(() -> this.shard.relocated(this.request.targetAllocationId(), this.recoveryTarget::handoffPrimaryContext));
            }
            stopWatch.stop();
            this.logger.trace("finalizing recovery took [{}]", (Object)stopWatch.totalTime());
            listener.onResponse(null);
        }, listener::onFailure);
    }

    public void cancel(String reason) {
        this.cancellableThreads.cancel(reason);
    }

    public String toString() {
        return "ShardRecoveryHandler{shardId=" + this.request.shardId() + ", sourceNode=" + this.request.sourceNode() + ", targetNode=" + this.request.targetNode() + '}';
    }

    void sendFiles(Store store, StoreFileMetaData[] files, IntSupplier translogOps) throws Exception {
        ArrayUtil.timSort(files, Comparator.comparingLong(StoreFileMetaData::length));
        LocalCheckpointTracker requestSeqIdTracker = new LocalCheckpointTracker(-1L, -1L);
        AtomicReference<Tuple<StoreFileMetaData, Exception>> error = new AtomicReference<Tuple<StoreFileMetaData, Exception>>();
        byte[] buffer = new byte[this.chunkSizeInBytes];
        block12: for (StoreFileMetaData md : files) {
            if (error.get() != null) break;
            try (IndexInput indexInput = store.directory().openInput(md.name(), IOContext.READONCE);
                 InputStreamIndexInput in = new InputStreamIndexInput(indexInput, md.length());){
                int bytesRead;
                long position = 0L;
                while ((bytesRead = ((InputStream)in).read(buffer, 0, buffer.length)) != -1) {
                    BytesArray content = new BytesArray(buffer, 0, bytesRead);
                    boolean lastChunk = position + (long)content.length() == md.length();
                    long requestSeqId = requestSeqIdTracker.generateSeqNo();
                    this.cancellableThreads.execute(() -> requestSeqIdTracker.waitForProcessedOpsToComplete(requestSeqId - (long)this.maxConcurrentFileChunks));
                    this.cancellableThreads.checkForCancel();
                    if (error.get() != null) {
                        continue block12;
                    }
                    long requestFilePosition = position;
                    this.cancellableThreads.executeIO(() -> this.recoveryTarget.writeFileChunk(md, requestFilePosition, content, lastChunk, translogOps.getAsInt(), ActionListener.wrap(r -> requestSeqIdTracker.markSeqNoAsProcessed(requestSeqId), e -> {
                        error.compareAndSet(null, Tuple.tuple(md, e));
                        requestSeqIdTracker.markSeqNoAsProcessed(requestSeqId);
                    })));
                    position += (long)content.length();
                }
            }
            catch (Exception e) {
                error.compareAndSet(null, Tuple.tuple(md, e));
                break;
            }
        }
        if (error.get() == null) {
            this.cancellableThreads.execute(() -> requestSeqIdTracker.waitForProcessedOpsToComplete(requestSeqIdTracker.getMaxSeqNo()));
        }
        if (error.get() != null) {
            this.handleErrorOnSendFiles(store, (Exception)((Tuple)error.get()).v2(), new StoreFileMetaData[]{(StoreFileMetaData)((Tuple)error.get()).v1()});
        }
    }

    private void cleanFiles(Store store, Store.MetadataSnapshot sourceMetadata, IntSupplier translogOps, long globalCheckpoint, ActionListener<Void> listener) {
        this.cancellableThreads.execute(() -> this.recoveryTarget.cleanFiles(translogOps.getAsInt(), globalCheckpoint, sourceMetadata, ActionListener.delegateResponse(listener, (l, e) -> ActionListener.completeWith(l, () -> {
            StoreFileMetaData[] mds = (StoreFileMetaData[])StreamSupport.stream(sourceMetadata.spliterator(), false).toArray(StoreFileMetaData[]::new);
            ArrayUtil.timSort(mds, Comparator.comparingLong(StoreFileMetaData::length));
            this.handleErrorOnSendFiles(store, (Exception)e, mds);
            throw e;
        }))));
    }

    private void handleErrorOnSendFiles(Store store, Exception e, StoreFileMetaData[] mds) throws Exception {
        IOException corruptIndexException = ExceptionsHelper.unwrapCorruption(e);
        if (corruptIndexException != null) {
            IOException localException = null;
            for (StoreFileMetaData md : mds) {
                this.cancellableThreads.checkForCancel();
                this.logger.debug("checking integrity for file {} after remove corruption exception", (Object)md);
                if (store.checkIntegrityNoException(md)) continue;
                this.logger.warn("{} Corrupted file detected {} checksum mismatch", (Object)this.shardId, (Object)md);
                if (localException == null) {
                    localException = corruptIndexException;
                }
                this.failEngine(corruptIndexException);
            }
            if (localException != null) {
                throw localException;
            }
            RemoteTransportException remoteException = new RemoteTransportException("File corruption occurred on recovery but checksums are ok", null);
            remoteException.addSuppressed(e);
            this.logger.warn(() -> new ParameterizedMessage("{} Remote file corruption on node {}, recovering {}. local checksum OK", this.shardId, this.request.targetNode(), mds), (Throwable)corruptIndexException);
            throw remoteException;
        }
        throw e;
    }

    protected void failEngine(IOException cause) {
        this.shard.failShard("recovery", cause);
    }

    static final class SendSnapshotResult {
        final long targetLocalCheckpoint;
        final int totalOperations;
        final TimeValue tookTime;

        SendSnapshotResult(long targetLocalCheckpoint, int totalOperations, TimeValue tookTime) {
            this.targetLocalCheckpoint = targetLocalCheckpoint;
            this.totalOperations = totalOperations;
            this.tookTime = tookTime;
        }
    }

    static final class SendFileResult {
        final List<String> phase1FileNames;
        final List<Long> phase1FileSizes;
        final long totalSize;
        final List<String> phase1ExistingFileNames;
        final List<Long> phase1ExistingFileSizes;
        final long existingTotalSize;
        final TimeValue took;
        static final SendFileResult EMPTY = new SendFileResult(Collections.emptyList(), Collections.emptyList(), 0L, Collections.emptyList(), Collections.emptyList(), 0L, TimeValue.ZERO);

        SendFileResult(List<String> phase1FileNames, List<Long> phase1FileSizes, long totalSize, List<String> phase1ExistingFileNames, List<Long> phase1ExistingFileSizes, long existingTotalSize, TimeValue took) {
            this.phase1FileNames = phase1FileNames;
            this.phase1FileSizes = phase1FileSizes;
            this.totalSize = totalSize;
            this.phase1ExistingFileNames = phase1ExistingFileNames;
            this.phase1ExistingFileSizes = phase1ExistingFileSizes;
            this.existingTotalSize = existingTotalSize;
            this.took = took;
        }
    }
}

