/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.indices.flush;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.flink.elasticsearch7.shaded.org.apache.logging.log4j.LogManager;
import org.apache.flink.elasticsearch7.shaded.org.apache.logging.log4j.Logger;
import org.apache.flink.elasticsearch7.shaded.org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ElasticsearchException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.StepListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.flush.FlushRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.flush.SyncedFlushResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.IndicesOptions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.ClusterState;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.IndexMetaData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.node.DiscoveryNode;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.ShardRouting;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.service.ClusterService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.UUIDs;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.inject.Inject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.concurrent.CountDown;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.Index;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.IndexNotFoundException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.IndexService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.engine.CommitStats;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.engine.Engine;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.shard.IndexEventListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.shard.IndexShard;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.shard.ShardId;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.shard.ShardNotFoundException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.indices.IndexClosedException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.indices.IndicesService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.indices.flush.ShardsSyncedFlushResult;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.tasks.Task;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportChannel;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportRequestHandler;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportResponseHandler;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportService;

public class SyncedFlushService
implements IndexEventListener {
    private static final Logger logger = LogManager.getLogger(SyncedFlushService.class);
    private static final String PRE_SYNCED_FLUSH_ACTION_NAME = "internal:indices/flush/synced/pre";
    private static final String SYNCED_FLUSH_ACTION_NAME = "internal:indices/flush/synced/sync";
    private static final String IN_FLIGHT_OPS_ACTION_NAME = "internal:indices/flush/synced/in_flight";
    private final IndicesService indicesService;
    private final ClusterService clusterService;
    private final TransportService transportService;
    private final IndexNameExpressionResolver indexNameExpressionResolver;

    @Inject
    public SyncedFlushService(IndicesService indicesService, ClusterService clusterService, TransportService transportService, IndexNameExpressionResolver indexNameExpressionResolver) {
        this.indicesService = indicesService;
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.indexNameExpressionResolver = indexNameExpressionResolver;
        transportService.registerRequestHandler(PRE_SYNCED_FLUSH_ACTION_NAME, PreShardSyncedFlushRequest::new, "flush", new PreSyncedFlushTransportHandler());
        transportService.registerRequestHandler(SYNCED_FLUSH_ACTION_NAME, ShardSyncedFlushRequest::new, "flush", new SyncedFlushTransportHandler());
        transportService.registerRequestHandler(IN_FLIGHT_OPS_ACTION_NAME, InFlightOpsRequest::new, "same", new InFlightOpCountTransportHandler());
    }

    @Override
    public void onShardInactive(final IndexShard indexShard) {
        if (indexShard.routingEntry().primary()) {
            this.attemptSyncedFlush(indexShard.shardId(), new ActionListener<ShardsSyncedFlushResult>(){

                @Override
                public void onResponse(ShardsSyncedFlushResult syncedFlushResult) {
                    logger.trace("{} sync flush on inactive shard returned successfully for sync_id: {}", (Object)syncedFlushResult.getShardId(), (Object)syncedFlushResult.syncId());
                }

                @Override
                public void onFailure(Exception e) {
                    logger.debug(() -> new ParameterizedMessage("{} sync flush on inactive shard failed", (Object)indexShard.shardId()), (Throwable)e);
                }
            });
        }
    }

    public void attemptSyncedFlush(String[] aliasesOrIndices, IndicesOptions indicesOptions, final ActionListener<SyncedFlushResponse> listener) {
        ClusterState state = this.clusterService.state();
        Index[] concreteIndices = this.indexNameExpressionResolver.concreteIndices(state, indicesOptions, aliasesOrIndices);
        final ConcurrentMap<String, List<ShardsSyncedFlushResult>> results = ConcurrentCollections.newConcurrentMap();
        int numberOfShards = 0;
        for (Index index : concreteIndices) {
            IndexMetaData indexMetaData = state.metaData().getIndexSafe(index);
            numberOfShards += indexMetaData.getNumberOfShards();
            results.put(index.getName(), Collections.synchronizedList(new ArrayList()));
        }
        if (numberOfShards == 0) {
            listener.onResponse(new SyncedFlushResponse(results));
            return;
        }
        final CountDown countDown = new CountDown(numberOfShards);
        for (Index concreteIndex : concreteIndices) {
            final String index = concreteIndex.getName();
            final IndexMetaData indexMetaData = state.metaData().getIndexSafe(concreteIndex);
            int indexNumberOfShards = indexMetaData.getNumberOfShards();
            for (int shard = 0; shard < indexNumberOfShards; ++shard) {
                final ShardId shardId = new ShardId(indexMetaData.getIndex(), shard);
                this.innerAttemptSyncedFlush(shardId, state, new ActionListener<ShardsSyncedFlushResult>(){

                    @Override
                    public void onResponse(ShardsSyncedFlushResult syncedFlushResult) {
                        ((List)results.get(index)).add(syncedFlushResult);
                        if (countDown.countDown()) {
                            listener.onResponse(new SyncedFlushResponse(results));
                        }
                    }

                    @Override
                    public void onFailure(Exception e) {
                        logger.debug("{} unexpected error while executing synced flush", (Object)shardId);
                        int totalShards = indexMetaData.getNumberOfReplicas() + 1;
                        ((List)results.get(index)).add(new ShardsSyncedFlushResult(shardId, totalShards, e.getMessage()));
                        if (countDown.countDown()) {
                            listener.onResponse(new SyncedFlushResponse(results));
                        }
                    }
                });
            }
        }
    }

    public void attemptSyncedFlush(ShardId shardId, ActionListener<ShardsSyncedFlushResult> actionListener) {
        this.innerAttemptSyncedFlush(shardId, this.clusterService.state(), actionListener);
    }

    private void innerAttemptSyncedFlush(ShardId shardId, ClusterState state, ActionListener<ShardsSyncedFlushResult> actionListener) {
        try {
            IndexShardRoutingTable shardRoutingTable = this.getShardRoutingTable(shardId, state);
            List<ShardRouting> activeShards = shardRoutingTable.activeShards();
            int totalShards = shardRoutingTable.getSize();
            if (activeShards.size() == 0) {
                actionListener.onResponse(new ShardsSyncedFlushResult(shardId, totalShards, "no active shards"));
                return;
            }
            StepListener<Map<String, PreSyncedFlushResponse>> presyncStep = new StepListener<Map<String, PreSyncedFlushResponse>>();
            this.sendPreSyncRequests(activeShards, state, shardId, presyncStep);
            StepListener<InFlightOpsResponse> inflightOpsStep = new StepListener<InFlightOpsResponse>();
            presyncStep.whenComplete(presyncResponses -> {
                if (presyncResponses.isEmpty()) {
                    actionListener.onResponse(new ShardsSyncedFlushResult(shardId, totalShards, "all shards failed to commit on pre-sync"));
                } else {
                    this.getInflightOpsCount(shardId, state, shardRoutingTable, inflightOpsStep);
                }
            }, actionListener::onFailure);
            inflightOpsStep.whenComplete(inFlightOpsResponse -> {
                Map presyncResponses = (Map)presyncStep.result();
                int inflight = inFlightOpsResponse.opCount();
                assert (inflight >= 0);
                if (inflight != 0) {
                    actionListener.onResponse(new ShardsSyncedFlushResult(shardId, totalShards, "[" + inflight + "] ongoing operations on primary"));
                } else {
                    String sharedSyncId = this.sharedExistingSyncId(presyncResponses);
                    if (sharedSyncId != null) {
                        assert (presyncResponses.values().stream().allMatch(r -> r.existingSyncId.equals(sharedSyncId))) : "Not all shards have the same existing sync id [" + sharedSyncId + "], responses [" + presyncResponses + "]";
                        this.reportSuccessWithExistingSyncId(shardId, sharedSyncId, activeShards, totalShards, presyncResponses, actionListener);
                    } else {
                        String syncId = UUIDs.randomBase64UUID();
                        this.sendSyncRequests(syncId, activeShards, state, presyncResponses, shardId, totalShards, actionListener);
                    }
                }
            }, actionListener::onFailure);
        }
        catch (Exception e) {
            actionListener.onFailure(e);
        }
    }

    private String sharedExistingSyncId(Map<String, PreSyncedFlushResponse> preSyncedFlushResponses) {
        String existingSyncId = null;
        for (PreSyncedFlushResponse resp : preSyncedFlushResponses.values()) {
            if (Strings.isNullOrEmpty(resp.existingSyncId)) {
                return null;
            }
            if (existingSyncId == null) {
                existingSyncId = resp.existingSyncId;
            }
            if (existingSyncId.equals(resp.existingSyncId)) continue;
            return null;
        }
        return existingSyncId;
    }

    private void reportSuccessWithExistingSyncId(ShardId shardId, String existingSyncId, List<ShardRouting> shards, int totalShards, Map<String, PreSyncedFlushResponse> preSyncResponses, ActionListener<ShardsSyncedFlushResult> listener) {
        HashMap<ShardRouting, ShardSyncedFlushResponse> results = new HashMap<ShardRouting, ShardSyncedFlushResponse>();
        for (ShardRouting shard : shards) {
            if (!preSyncResponses.containsKey(shard.currentNodeId())) continue;
            results.put(shard, new ShardSyncedFlushResponse());
        }
        listener.onResponse(new ShardsSyncedFlushResult(shardId, existingSyncId, totalShards, results));
    }

    final IndexShardRoutingTable getShardRoutingTable(ShardId shardId, ClusterState state) {
        IndexMetaData indexMetaData = state.getMetaData().index(shardId.getIndex());
        if (indexMetaData == null) {
            throw new IndexNotFoundException(shardId.getIndexName());
        }
        if (indexMetaData.getState() == IndexMetaData.State.CLOSE) {
            throw new IndexClosedException(shardId.getIndex());
        }
        IndexShardRoutingTable shardRoutingTable = state.routingTable().index(indexMetaData.getIndex()).shard(shardId.id());
        if (shardRoutingTable == null) {
            throw new ShardNotFoundException(shardId);
        }
        return shardRoutingTable;
    }

    protected void getInflightOpsCount(final ShardId shardId, ClusterState state, IndexShardRoutingTable shardRoutingTable, final ActionListener<InFlightOpsResponse> listener) {
        try {
            ShardRouting primaryShard = shardRoutingTable.primaryShard();
            DiscoveryNode primaryNode = state.nodes().get(primaryShard.currentNodeId());
            if (primaryNode == null) {
                logger.trace("{} failed to resolve node for primary shard {}, skipping sync", (Object)shardId, (Object)primaryShard);
                listener.onResponse(new InFlightOpsResponse(-1));
                return;
            }
            logger.trace("{} retrieving in flight operation count", (Object)shardId);
            this.transportService.sendRequest(primaryNode, IN_FLIGHT_OPS_ACTION_NAME, new InFlightOpsRequest(shardId), new TransportResponseHandler<InFlightOpsResponse>(){

                @Override
                public InFlightOpsResponse read(StreamInput in) throws IOException {
                    InFlightOpsResponse response = new InFlightOpsResponse();
                    response.readFrom(in);
                    return response;
                }

                @Override
                public void handleResponse(InFlightOpsResponse response) {
                    listener.onResponse(response);
                }

                @Override
                public void handleException(TransportException exp) {
                    logger.debug("{} unexpected error while retrieving in flight op count", (Object)shardId);
                    listener.onFailure(exp);
                }

                @Override
                public String executor() {
                    return "same";
                }
            });
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private int numDocsOnPrimary(List<ShardRouting> shards, Map<String, PreSyncedFlushResponse> preSyncResponses) {
        for (ShardRouting shard : shards) {
            PreSyncedFlushResponse resp;
            if (!shard.primary() || (resp = preSyncResponses.get(shard.currentNodeId())) == null) continue;
            return resp.numDocs;
        }
        return -1;
    }

    void sendSyncRequests(final String syncId, final List<ShardRouting> shards, ClusterState state, Map<String, PreSyncedFlushResponse> preSyncResponses, final ShardId shardId, final int totalShards, final ActionListener<ShardsSyncedFlushResult> listener) {
        final CountDown countDown = new CountDown(shards.size());
        final ConcurrentMap<ShardRouting, ShardSyncedFlushResponse> results = ConcurrentCollections.newConcurrentMap();
        int numDocsOnPrimary = this.numDocsOnPrimary(shards, preSyncResponses);
        for (final ShardRouting shard : shards) {
            final DiscoveryNode node = state.nodes().get(shard.currentNodeId());
            if (node == null) {
                logger.trace("{} is assigned to an unknown node. skipping for sync id [{}]. shard routing {}", (Object)shardId, (Object)syncId, (Object)shard);
                results.put(shard, new ShardSyncedFlushResponse("unknown node"));
                this.countDownAndSendResponseIfDone(syncId, shards, shardId, totalShards, listener, countDown, results);
                continue;
            }
            PreSyncedFlushResponse preSyncedResponse = preSyncResponses.get(shard.currentNodeId());
            if (preSyncedResponse == null) {
                logger.trace("{} can't resolve expected commit id for current node, skipping for sync id [{}]. shard routing {}", (Object)shardId, (Object)syncId, (Object)shard);
                results.put(shard, new ShardSyncedFlushResponse("no commit id from pre-sync flush"));
                this.countDownAndSendResponseIfDone(syncId, shards, shardId, totalShards, listener, countDown, results);
                continue;
            }
            if (preSyncedResponse.numDocs != numDocsOnPrimary && preSyncedResponse.numDocs != -1 && numDocsOnPrimary != -1) {
                logger.warn("{} can't to issue sync id [{}] for out of sync replica [{}] with num docs [{}]; num docs on primary [{}]", (Object)shardId, (Object)syncId, (Object)shard, (Object)preSyncedResponse.numDocs, (Object)numDocsOnPrimary);
                results.put(shard, new ShardSyncedFlushResponse("out of sync replica; num docs on replica [" + preSyncedResponse.numDocs + "]; num docs on primary [" + numDocsOnPrimary + "]"));
                this.countDownAndSendResponseIfDone(syncId, shards, shardId, totalShards, listener, countDown, results);
                continue;
            }
            logger.trace("{} sending synced flush request to {}. sync id [{}].", (Object)shardId, (Object)shard, (Object)syncId);
            ShardSyncedFlushRequest syncedFlushRequest = new ShardSyncedFlushRequest(shard.shardId(), syncId, preSyncedResponse.commitId);
            this.transportService.sendRequest(node, SYNCED_FLUSH_ACTION_NAME, syncedFlushRequest, new TransportResponseHandler<ShardSyncedFlushResponse>(){

                @Override
                public ShardSyncedFlushResponse read(StreamInput in) throws IOException {
                    ShardSyncedFlushResponse response = new ShardSyncedFlushResponse();
                    response.readFrom(in);
                    return response;
                }

                @Override
                public void handleResponse(ShardSyncedFlushResponse response) {
                    ShardSyncedFlushResponse existing = results.put(shard, response);
                    assert (existing == null) : "got two answers for node [" + node + "]";
                    SyncedFlushService.this.countDownAndSendResponseIfDone(syncId, shards, shardId, totalShards, listener, countDown, results);
                }

                @Override
                public void handleException(TransportException exp) {
                    logger.trace(() -> new ParameterizedMessage("{} error while performing synced flush on [{}], skipping", (Object)shardId, (Object)shard), (Throwable)exp);
                    results.put(shard, new ShardSyncedFlushResponse(exp.getMessage()));
                    SyncedFlushService.this.countDownAndSendResponseIfDone(syncId, shards, shardId, totalShards, listener, countDown, results);
                }

                @Override
                public String executor() {
                    return "same";
                }
            });
        }
    }

    private void countDownAndSendResponseIfDone(String syncId, List<ShardRouting> shards, ShardId shardId, int totalShards, ActionListener<ShardsSyncedFlushResult> listener, CountDown countDown, Map<ShardRouting, ShardSyncedFlushResponse> results) {
        if (countDown.countDown()) {
            assert (results.size() == shards.size());
            listener.onResponse(new ShardsSyncedFlushResult(shardId, syncId, totalShards, results));
        }
    }

    void sendPreSyncRequests(List<ShardRouting> shards, ClusterState state, final ShardId shardId, final ActionListener<Map<String, PreSyncedFlushResponse>> listener) {
        final CountDown countDown = new CountDown(shards.size());
        final ConcurrentMap presyncResponses = ConcurrentCollections.newConcurrentMap();
        for (final ShardRouting shard : shards) {
            logger.trace("{} sending pre-synced flush request to {}", (Object)shardId, (Object)shard);
            final DiscoveryNode node = state.nodes().get(shard.currentNodeId());
            if (node == null) {
                logger.trace("{} shard routing {} refers to an unknown node. skipping.", (Object)shardId, (Object)shard);
                if (!countDown.countDown()) continue;
                listener.onResponse(presyncResponses);
                continue;
            }
            this.transportService.sendRequest(node, PRE_SYNCED_FLUSH_ACTION_NAME, new PreShardSyncedFlushRequest(shard.shardId()), new TransportResponseHandler<PreSyncedFlushResponse>(){

                @Override
                public PreSyncedFlushResponse read(StreamInput in) throws IOException {
                    PreSyncedFlushResponse response = new PreSyncedFlushResponse();
                    response.readFrom(in);
                    return response;
                }

                @Override
                public void handleResponse(PreSyncedFlushResponse response) {
                    PreSyncedFlushResponse existing = presyncResponses.putIfAbsent(node.getId(), response);
                    assert (existing == null) : "got two answers for node [" + node + "]";
                    if (countDown.countDown()) {
                        listener.onResponse(presyncResponses);
                    }
                }

                @Override
                public void handleException(TransportException exp) {
                    logger.trace(() -> new ParameterizedMessage("{} error while performing pre synced flush on [{}], skipping", (Object)shardId, (Object)shard), (Throwable)exp);
                    if (countDown.countDown()) {
                        listener.onResponse(presyncResponses);
                    }
                }

                @Override
                public String executor() {
                    return "same";
                }
            });
        }
    }

    private PreSyncedFlushResponse performPreSyncedFlush(PreShardSyncedFlushRequest request) {
        IndexShard indexShard = this.indicesService.indexServiceSafe(request.shardId().getIndex()).getShard(request.shardId().id());
        FlushRequest flushRequest = new FlushRequest(new String[0]).force(false).waitIfOngoing(true);
        logger.trace("{} performing pre sync flush", (Object)request.shardId());
        indexShard.flush(flushRequest);
        CommitStats commitStats = indexShard.commitStats();
        Engine.CommitId commitId = commitStats.getRawCommitId();
        logger.trace("{} pre sync flush done. commit id {}, num docs {}", (Object)request.shardId(), (Object)commitId, (Object)commitStats.getNumDocs());
        return new PreSyncedFlushResponse(commitId, commitStats.getNumDocs(), commitStats.syncId());
    }

    private ShardSyncedFlushResponse performSyncedFlush(ShardSyncedFlushRequest request) {
        IndexService indexService = this.indicesService.indexServiceSafe(request.shardId().getIndex());
        IndexShard indexShard = indexService.getShard(request.shardId().id());
        logger.trace("{} performing sync flush. sync id [{}], expected commit id {}", (Object)request.shardId(), (Object)request.syncId(), (Object)request.expectedCommitId());
        Engine.SyncedFlushResult result = indexShard.syncFlush(request.syncId(), request.expectedCommitId());
        logger.trace("{} sync flush done. sync id [{}], result [{}]", (Object)request.shardId(), (Object)request.syncId(), (Object)result);
        switch (result) {
            case SUCCESS: {
                return new ShardSyncedFlushResponse();
            }
            case COMMIT_MISMATCH: {
                return new ShardSyncedFlushResponse("commit has changed");
            }
            case PENDING_OPERATIONS: {
                return new ShardSyncedFlushResponse("pending operations");
            }
        }
        throw new ElasticsearchException("unknown synced flush result [" + (Object)((Object)result) + "]", new Object[0]);
    }

    private InFlightOpsResponse performInFlightOps(InFlightOpsRequest request) {
        IndexService indexService = this.indicesService.indexServiceSafe(request.shardId().getIndex());
        IndexShard indexShard = indexService.getShard(request.shardId().id());
        if (!indexShard.routingEntry().primary()) {
            throw new IllegalStateException("[" + request.shardId() + "] expected a primary shard");
        }
        int opCount = indexShard.getActiveOperationsCount();
        return new InFlightOpsResponse(opCount == -1 ? 0 : opCount);
    }

    private final class InFlightOpCountTransportHandler
    implements TransportRequestHandler<InFlightOpsRequest> {
        private InFlightOpCountTransportHandler() {
        }

        @Override
        public void messageReceived(InFlightOpsRequest request, TransportChannel channel, Task task) throws Exception {
            channel.sendResponse(SyncedFlushService.this.performInFlightOps(request));
        }
    }

    private final class SyncedFlushTransportHandler
    implements TransportRequestHandler<ShardSyncedFlushRequest> {
        private SyncedFlushTransportHandler() {
        }

        @Override
        public void messageReceived(ShardSyncedFlushRequest request, TransportChannel channel, Task task) throws Exception {
            channel.sendResponse(SyncedFlushService.this.performSyncedFlush(request));
        }
    }

    private final class PreSyncedFlushTransportHandler
    implements TransportRequestHandler<PreShardSyncedFlushRequest> {
        private PreSyncedFlushTransportHandler() {
        }

        @Override
        public void messageReceived(PreShardSyncedFlushRequest request, TransportChannel channel, Task task) throws Exception {
            channel.sendResponse(SyncedFlushService.this.performPreSyncedFlush(request));
        }
    }

    static final class InFlightOpsResponse
    extends TransportResponse {
        int opCount;

        InFlightOpsResponse() {
        }

        InFlightOpsResponse(int opCount) {
            assert (opCount >= 0) : opCount;
            this.opCount = opCount;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.opCount = in.readVInt();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeVInt(this.opCount);
        }

        public int opCount() {
            return this.opCount;
        }

        public String toString() {
            return "InFlightOpsResponse{opCount=" + this.opCount + '}';
        }
    }

    public static final class InFlightOpsRequest
    extends TransportRequest {
        private ShardId shardId;

        public InFlightOpsRequest() {
        }

        public InFlightOpsRequest(ShardId shardId) {
            this.shardId = shardId;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.shardId = new ShardId(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.shardId.writeTo(out);
        }

        public ShardId shardId() {
            return this.shardId;
        }

        public String toString() {
            return "InFlightOpsRequest{shardId=" + this.shardId + '}';
        }
    }

    public static final class ShardSyncedFlushResponse
    extends TransportResponse {
        String failureReason;

        public ShardSyncedFlushResponse() {
            this.failureReason = null;
        }

        public ShardSyncedFlushResponse(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.failureReason = in.readOptionalString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeOptionalString(this.failureReason);
        }

        public boolean success() {
            return this.failureReason == null;
        }

        public String failureReason() {
            return this.failureReason;
        }

        public String toString() {
            return "ShardSyncedFlushResponse{success=" + this.success() + ", failureReason='" + this.failureReason + '\'' + '}';
        }

        public static ShardSyncedFlushResponse readSyncedFlushResponse(StreamInput in) throws IOException {
            ShardSyncedFlushResponse shardSyncedFlushResponse = new ShardSyncedFlushResponse();
            shardSyncedFlushResponse.readFrom(in);
            return shardSyncedFlushResponse;
        }
    }

    public static final class ShardSyncedFlushRequest
    extends TransportRequest {
        private String syncId;
        private Engine.CommitId expectedCommitId;
        private ShardId shardId;

        public ShardSyncedFlushRequest() {
        }

        public ShardSyncedFlushRequest(ShardId shardId, String syncId, Engine.CommitId expectedCommitId) {
            this.expectedCommitId = expectedCommitId;
            this.shardId = shardId;
            this.syncId = syncId;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.shardId = new ShardId(in);
            this.expectedCommitId = new Engine.CommitId(in);
            this.syncId = in.readString();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.shardId.writeTo(out);
            this.expectedCommitId.writeTo(out);
            out.writeString(this.syncId);
        }

        public ShardId shardId() {
            return this.shardId;
        }

        public String syncId() {
            return this.syncId;
        }

        public Engine.CommitId expectedCommitId() {
            return this.expectedCommitId;
        }

        public String toString() {
            return "ShardSyncedFlushRequest{shardId=" + this.shardId + ",syncId='" + this.syncId + '\'' + '}';
        }
    }

    static final class PreSyncedFlushResponse
    extends TransportResponse {
        static final int UNKNOWN_NUM_DOCS = -1;
        Engine.CommitId commitId;
        int numDocs;
        @Nullable
        String existingSyncId = null;

        PreSyncedFlushResponse() {
        }

        PreSyncedFlushResponse(Engine.CommitId commitId, int numDocs, String existingSyncId) {
            this.commitId = commitId;
            this.numDocs = numDocs;
            this.existingSyncId = existingSyncId;
        }

        boolean includeNumDocs(Version version) {
            return version.onOrAfter(Version.V_6_2_2);
        }

        boolean includeExistingSyncId(Version version) {
            return version.onOrAfter(Version.V_6_3_0);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.commitId = new Engine.CommitId(in);
            this.numDocs = this.includeNumDocs(in.getVersion()) ? in.readInt() : -1;
            if (this.includeExistingSyncId(in.getVersion())) {
                this.existingSyncId = in.readOptionalString();
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.commitId.writeTo(out);
            if (this.includeNumDocs(out.getVersion())) {
                out.writeInt(this.numDocs);
            }
            if (this.includeExistingSyncId(out.getVersion())) {
                out.writeOptionalString(this.existingSyncId);
            }
        }
    }

    public static final class PreShardSyncedFlushRequest
    extends TransportRequest {
        private ShardId shardId;

        public PreShardSyncedFlushRequest() {
        }

        public PreShardSyncedFlushRequest(ShardId shardId) {
            this.shardId = shardId;
        }

        public String toString() {
            return "PreShardSyncedFlushRequest{shardId=" + this.shardId + '}';
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.shardId.writeTo(out);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.shardId = new ShardId(in);
        }

        public ShardId shardId() {
            return this.shardId;
        }
    }
}

