/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.snapshots.blobstore;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.RateLimiter;

public class RateLimitingInputStream
extends FilterInputStream {
    private final RateLimiter rateLimiter;
    private final Listener listener;
    private long bytesSinceLastRateLimit;

    public RateLimitingInputStream(InputStream delegate, RateLimiter rateLimiter, Listener listener) {
        super(delegate);
        this.rateLimiter = rateLimiter;
        this.listener = listener;
    }

    private void maybePause(int bytes) throws IOException {
        this.bytesSinceLastRateLimit += (long)bytes;
        if (this.bytesSinceLastRateLimit >= this.rateLimiter.getMinPauseCheckBytes()) {
            long pause = this.rateLimiter.pause(this.bytesSinceLastRateLimit);
            this.bytesSinceLastRateLimit = 0L;
            if (pause > 0L) {
                this.listener.onPause(pause);
            }
        }
    }

    @Override
    public int read() throws IOException {
        int b = super.read();
        this.maybePause(1);
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int n = super.read(b, off, len);
        if (n > 0) {
            this.maybePause(n);
        }
        return n;
    }

    public static interface Listener {
        public void onPause(long var1);
    }
}

