/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.rankeval;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.node.DiscoveryNodes;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.ClusterSettings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.IndexScopedSettings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.SettingsFilter;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.rankeval.DiscountedCumulativeGain;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.rankeval.EvaluationMetric;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.rankeval.ExpectedReciprocalRank;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.rankeval.MeanReciprocalRank;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.rankeval.MetricDetail;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.rankeval.PrecisionAtK;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.rankeval.RankEvalAction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.rankeval.RankEvalNamedXContentProvider;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.rankeval.RestRankEvalAction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.rankeval.TransportRankEvalAction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.plugins.ActionPlugin;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.plugins.Plugin;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestController;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestHandler;

public class RankEvalPlugin
extends Plugin
implements ActionPlugin {
    @Override
    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        return Arrays.asList(new ActionPlugin.ActionHandler(RankEvalAction.INSTANCE, TransportRankEvalAction.class, new Class[0]));
    }

    @Override
    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        return Arrays.asList(new RestRankEvalAction(settings, restController));
    }

    @Override
    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        ArrayList<NamedWriteableRegistry.Entry> namedWriteables = new ArrayList<NamedWriteableRegistry.Entry>();
        namedWriteables.add(new NamedWriteableRegistry.Entry(EvaluationMetric.class, "precision", PrecisionAtK::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(EvaluationMetric.class, "mean_reciprocal_rank", MeanReciprocalRank::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(EvaluationMetric.class, "dcg", DiscountedCumulativeGain::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(EvaluationMetric.class, "expected_reciprocal_rank", ExpectedReciprocalRank::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(MetricDetail.class, "precision", PrecisionAtK.Detail::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(MetricDetail.class, "mean_reciprocal_rank", MeanReciprocalRank.Detail::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(MetricDetail.class, "dcg", DiscountedCumulativeGain.Detail::new));
        namedWriteables.add(new NamedWriteableRegistry.Entry(MetricDetail.class, "expected_reciprocal_rank", ExpectedReciprocalRank.Detail::new));
        return namedWriteables;
    }

    @Override
    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        return new RankEvalNamedXContentProvider().getNamedXContentParsers();
    }
}

