/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.StoredField;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.ScoreMode;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Scorer;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Weight;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ElasticsearchGenerationException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.bytes.BytesArray;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.compress.CompressedXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.text.Text;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentFragment;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.IndexSettings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.analysis.IndexAnalyzers;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.ContentPath;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.DocumentFieldMappers;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.DocumentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.FieldAliasMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.FieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.IdFieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.IndexFieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MappedFieldType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.Mapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MapperParsingException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MapperService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MapperUtils;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.Mapping;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.ObjectMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.ParsedDocument;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.RootObjectMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.RoutingFieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.SourceFieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.SourceToParse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.TypeFieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.QueryShardContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal.SearchContext;

public class DocumentMapper
implements ToXContentFragment {
    private final MapperService mapperService;
    private final String type;
    private final Text typeText;
    private final CompressedXContent mappingSource;
    private final Mapping mapping;
    private final DocumentParser documentParser;
    private final DocumentFieldMappers fieldMappers;
    private final Map<String, ObjectMapper> objectMappers;
    private final boolean hasNestedObjects;
    private final MetadataFieldMapper[] deleteTombstoneMetadataFieldMappers;
    private final MetadataFieldMapper[] noopTombstoneMetadataFieldMappers;

    public DocumentMapper(MapperService mapperService, Mapping mapping) {
        this.mapperService = mapperService;
        this.type = mapping.root().name();
        this.typeText = new Text(this.type);
        IndexSettings indexSettings = mapperService.getIndexSettings();
        this.mapping = mapping;
        this.documentParser = new DocumentParser(indexSettings, mapperService.documentMapperParser(), this);
        ArrayList<ObjectMapper> newObjectMappers = new ArrayList<ObjectMapper>();
        ArrayList<FieldMapper> newFieldMappers = new ArrayList<FieldMapper>();
        ArrayList<FieldAliasMapper> newFieldAliasMappers = new ArrayList<FieldAliasMapper>();
        for (MetadataFieldMapper metadataFieldMapper : this.mapping.metadataMappers) {
            if (!(metadataFieldMapper instanceof FieldMapper)) continue;
            newFieldMappers.add(metadataFieldMapper);
        }
        MapperUtils.collect(this.mapping.root, newObjectMappers, newFieldMappers, newFieldAliasMappers);
        IndexAnalyzers indexAnalyzers = mapperService.getIndexAnalyzers();
        this.fieldMappers = new DocumentFieldMappers(newFieldMappers, newFieldAliasMappers, indexAnalyzers.getDefaultIndexAnalyzer(), indexAnalyzers.getDefaultSearchAnalyzer(), indexAnalyzers.getDefaultSearchQuoteAnalyzer());
        HashMap<String, ObjectMapper> builder = new HashMap<String, ObjectMapper>();
        for (ObjectMapper objectMapper : newObjectMappers) {
            ObjectMapper previous = builder.put(objectMapper.fullPath(), objectMapper);
            if (previous == null) continue;
            throw new IllegalStateException("duplicate key " + objectMapper.fullPath() + " encountered");
        }
        boolean hasNestedObjects = false;
        this.objectMappers = Collections.unmodifiableMap(builder);
        for (ObjectMapper objectMapper : newObjectMappers) {
            if (!objectMapper.nested().isNested()) continue;
            hasNestedObjects = true;
        }
        this.hasNestedObjects = hasNestedObjects;
        try {
            this.mappingSource = new CompressedXContent(this, XContentType.JSON, ToXContent.EMPTY_PARAMS);
        }
        catch (Exception exception) {
            throw new ElasticsearchGenerationException("failed to serialize source for type [" + this.type + "]", exception);
        }
        List<String> list = Arrays.asList("_version", "_id", "_type", "_seq_no", "_primary_term", "_tombstone");
        this.deleteTombstoneMetadataFieldMappers = (MetadataFieldMapper[])Stream.of(mapping.metadataMappers).filter(field -> deleteTombstoneMetadataFields.contains(field.name())).toArray(MetadataFieldMapper[]::new);
        List<String> noopTombstoneMetadataFields = Arrays.asList("_version", "_seq_no", "_primary_term", "_tombstone");
        this.noopTombstoneMetadataFieldMappers = (MetadataFieldMapper[])Stream.of(mapping.metadataMappers).filter(field -> noopTombstoneMetadataFields.contains(field.name())).toArray(MetadataFieldMapper[]::new);
    }

    public Mapping mapping() {
        return this.mapping;
    }

    public String type() {
        return this.type;
    }

    public Text typeText() {
        return this.typeText;
    }

    public Map<String, Object> meta() {
        return this.mapping.meta;
    }

    public CompressedXContent mappingSource() {
        return this.mappingSource;
    }

    public RootObjectMapper root() {
        return this.mapping.root;
    }

    public <T extends MetadataFieldMapper> T metadataMapper(Class<T> type) {
        return this.mapping.metadataMapper(type);
    }

    public IndexFieldMapper indexMapper() {
        return this.metadataMapper(IndexFieldMapper.class);
    }

    public TypeFieldMapper typeMapper() {
        return this.metadataMapper(TypeFieldMapper.class);
    }

    public SourceFieldMapper sourceMapper() {
        return this.metadataMapper(SourceFieldMapper.class);
    }

    public IdFieldMapper idFieldMapper() {
        return this.metadataMapper(IdFieldMapper.class);
    }

    public RoutingFieldMapper routingFieldMapper() {
        return this.metadataMapper(RoutingFieldMapper.class);
    }

    public IndexFieldMapper IndexFieldMapper() {
        return this.metadataMapper(IndexFieldMapper.class);
    }

    public Query typeFilter(QueryShardContext context) {
        return this.typeMapper().fieldType().termQuery(this.type, context);
    }

    public boolean hasNestedObjects() {
        return this.hasNestedObjects;
    }

    public DocumentFieldMappers mappers() {
        return this.fieldMappers;
    }

    public Map<String, ObjectMapper> objectMappers() {
        return this.objectMappers;
    }

    public ParsedDocument parse(SourceToParse source) throws MapperParsingException {
        return this.documentParser.parseDocument(source, this.mapping.metadataMappers);
    }

    public ParsedDocument createDeleteTombstoneDoc(String index, String type, String id) throws MapperParsingException {
        SourceToParse emptySource = new SourceToParse(index, type, id, new BytesArray("{}"), XContentType.JSON);
        return this.documentParser.parseDocument(emptySource, this.deleteTombstoneMetadataFieldMappers).toTombstone();
    }

    public ParsedDocument createNoopTombstoneDoc(String index, String reason) throws MapperParsingException {
        String id = "";
        SourceToParse sourceToParse = new SourceToParse(index, this.type, "", new BytesArray("{}"), XContentType.JSON);
        ParsedDocument parsedDoc = this.documentParser.parseDocument(sourceToParse, this.noopTombstoneMetadataFieldMappers).toTombstone();
        BytesRef byteRef = new BytesRef(reason);
        parsedDoc.rootDoc().add(new StoredField("_source", byteRef.bytes, byteRef.offset, byteRef.length));
        return parsedDoc;
    }

    public ObjectMapper findNestedObjectMapper(int nestedDocId, SearchContext sc, LeafReaderContext context) throws IOException {
        ObjectMapper nestedObjectMapper = null;
        for (ObjectMapper objectMapper : this.objectMappers().values()) {
            Weight nestedWeight;
            Scorer scorer;
            Query filter;
            if (!objectMapper.nested().isNested() || (filter = objectMapper.nestedTypeFilter()) == null || (scorer = (nestedWeight = filter.createWeight(sc.searcher(), ScoreMode.COMPLETE_NO_SCORES, 1.0f)).scorer(context)) == null || scorer.iterator().advance(nestedDocId) != nestedDocId) continue;
            if (nestedObjectMapper == null) {
                nestedObjectMapper = objectMapper;
                continue;
            }
            if (nestedObjectMapper.fullPath().length() >= objectMapper.fullPath().length()) continue;
            nestedObjectMapper = objectMapper;
        }
        return nestedObjectMapper;
    }

    public DocumentMapper merge(Mapping mapping) {
        Mapping merged = this.mapping.merge(mapping);
        return new DocumentMapper(this.mapperService, merged);
    }

    public DocumentMapper updateFieldType(Map<String, MappedFieldType> fullNameToFieldType) {
        Mapping updated = this.mapping.updateFieldType(fullNameToFieldType);
        if (updated == this.mapping) {
            return this;
        }
        assert (updated == updated.updateFieldType(fullNameToFieldType)) : "updateFieldType operation is not idempotent";
        return new DocumentMapper(this.mapperService, updated);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.mapping.toXContent(builder, params);
    }

    public static class Builder {
        private Map<Class<? extends MetadataFieldMapper>, MetadataFieldMapper> metadataMappers = new LinkedHashMap<Class<? extends MetadataFieldMapper>, MetadataFieldMapper>();
        private final RootObjectMapper rootObjectMapper;
        private Map<String, Object> meta;
        private final Mapper.BuilderContext builderContext;

        public Builder(RootObjectMapper.Builder builder, MapperService mapperService) {
            Settings indexSettings = mapperService.getIndexSettings().getSettings();
            this.builderContext = new Mapper.BuilderContext(indexSettings, new ContentPath(1));
            this.rootObjectMapper = builder.build(this.builderContext);
            String type = this.rootObjectMapper.name();
            DocumentMapper existingMapper = mapperService.documentMapper(type);
            Version indexCreatedVersion = mapperService.getIndexSettings().getIndexVersionCreated();
            Map<String, MetadataFieldMapper.TypeParser> metadataMapperParsers = mapperService.mapperRegistry.getMetadataMapperParsers(indexCreatedVersion);
            for (Map.Entry<String, MetadataFieldMapper.TypeParser> entry : metadataMapperParsers.entrySet()) {
                MetadataFieldMapper metadataMapper;
                MetadataFieldMapper existingMetadataMapper;
                String name = entry.getKey();
                MetadataFieldMapper metadataFieldMapper = existingMetadataMapper = existingMapper == null ? null : (MetadataFieldMapper)existingMapper.mappers().getMapper(name);
                if (existingMetadataMapper == null) {
                    MetadataFieldMapper.TypeParser parser = entry.getValue();
                    metadataMapper = parser.getDefault(mapperService.fullName(name), mapperService.documentMapperParser().parserContext(builder.name()));
                } else {
                    metadataMapper = existingMetadataMapper;
                }
                this.metadataMappers.put(metadataMapper.getClass(), metadataMapper);
            }
        }

        public Builder meta(Map<String, Object> meta) {
            this.meta = meta;
            return this;
        }

        public Builder put(MetadataFieldMapper.Builder<?, ?> mapper) {
            MetadataFieldMapper metadataMapper = (MetadataFieldMapper)mapper.build(this.builderContext);
            this.metadataMappers.put(metadataMapper.getClass(), metadataMapper);
            return this;
        }

        public DocumentMapper build(MapperService mapperService) {
            Objects.requireNonNull(this.rootObjectMapper, "Mapper builder must have the root object mapper set");
            Mapping mapping = new Mapping(mapperService.getIndexSettings().getIndexVersionCreated(), this.rootObjectMapper, this.metadataMappers.values().toArray(new MetadataFieldMapper[this.metadataMappers.values().size()]), this.meta);
            return new DocumentMapper(mapperService, mapping);
        }
    }
}

