/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.blocktree.FieldReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.blocktree.Stats;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LeafReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.PostingsEnum;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.Terms;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.TermsEnum;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.SortField;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.PagedBytes;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.packed.PackedLongValues;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.breaker.CircuitBreaker;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.IndexSettings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.AtomicOrdinalsFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.IndexFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.IndexOrdinalsFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.RamAccountingTermsEnum;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.fieldcomparator.BytesRefFieldComparatorSource;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.ordinals.Ordinals;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.ordinals.OrdinalsBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.plain.AbstractAtomicOrdinalsFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.plain.AbstractIndexFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.plain.AbstractIndexOrdinalsFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.plain.PagedBytesAtomicFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MappedFieldType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MapperService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.MultiValueMode;

public class PagedBytesIndexFieldData
extends AbstractIndexOrdinalsFieldData {
    public PagedBytesIndexFieldData(IndexSettings indexSettings, String fieldName, IndexFieldDataCache cache, CircuitBreakerService breakerService, double minFrequency, double maxFrequency, int minSegmentSize) {
        super(indexSettings, fieldName, cache, breakerService, minFrequency, maxFrequency, minSegmentSize);
    }

    @Override
    public SortField sortField(@Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
        BytesRefFieldComparatorSource source = new BytesRefFieldComparatorSource(this, missingValue, sortMode, nested);
        return new SortField(this.getFieldName(), source, reverse);
    }

    @Override
    public AtomicOrdinalsFieldData loadDirect(LeafReaderContext context) throws Exception {
        LeafReader reader = context.reader();
        AtomicOrdinalsFieldData data = null;
        PagedBytesEstimator estimator = new PagedBytesEstimator(context, this.breakerService.getBreaker("fielddata"), this.getFieldName());
        Terms terms = reader.terms(this.getFieldName());
        if (terms == null) {
            data = AbstractAtomicOrdinalsFieldData.empty();
            estimator.afterLoad(null, data.ramBytesUsed());
            return data;
        }
        PagedBytes bytes = new PagedBytes(15);
        PackedLongValues.Builder termOrdToBytesOffset = PackedLongValues.monotonicBuilder(0.0f);
        float acceptableTransientOverheadRatio = 0.5f;
        TermsEnum termsEnum = estimator.beforeLoad(terms);
        boolean success = false;
        try {
            AtomicOrdinalsFieldData atomicOrdinalsFieldData;
            try (OrdinalsBuilder builder = new OrdinalsBuilder(reader.maxDoc(), 0.5f);){
                PostingsEnum docsEnum = null;
                BytesRef term = termsEnum.next();
                while (term != null) {
                    long termOrd = builder.nextOrdinal();
                    assert (termOrd == termOrdToBytesOffset.size());
                    termOrdToBytesOffset.add(bytes.copyUsingLengthPrefix(term));
                    docsEnum = termsEnum.postings(docsEnum, 0);
                    int docId = docsEnum.nextDoc();
                    while (docId != Integer.MAX_VALUE) {
                        builder.addDoc(docId);
                        docId = docsEnum.nextDoc();
                    }
                    term = termsEnum.next();
                }
                PagedBytes.Reader bytesReader = bytes.freeze(true);
                Ordinals ordinals = builder.build();
                data = new PagedBytesAtomicFieldData(bytesReader, termOrdToBytesOffset.build(), ordinals);
                success = true;
                atomicOrdinalsFieldData = data;
            }
            return atomicOrdinalsFieldData;
        }
        finally {
            if (!success) {
                estimator.afterLoad(termsEnum, 0L);
            } else {
                estimator.afterLoad(termsEnum, data.ramBytesUsed());
            }
        }
    }

    public class PagedBytesEstimator
    implements AbstractIndexFieldData.PerValueEstimator {
        private final LeafReaderContext context;
        private final CircuitBreaker breaker;
        private final String fieldName;
        private long estimatedBytes;

        PagedBytesEstimator(LeafReaderContext context, CircuitBreaker breaker, String fieldName) {
            this.breaker = breaker;
            this.context = context;
            this.fieldName = fieldName;
        }

        @Override
        public long bytesPerValue(BytesRef term) {
            if (term == null) {
                return 0L;
            }
            long bytes = term.length;
            bytes += 64L;
            bytes = (long)((double)bytes / 1.5) + 1L;
            return bytes;
        }

        public long estimateStringFieldData() {
            try {
                LeafReader reader = this.context.reader();
                Terms terms = reader.terms(PagedBytesIndexFieldData.this.getFieldName());
                Terms fieldTerms = reader.terms(PagedBytesIndexFieldData.this.getFieldName());
                if (fieldTerms instanceof FieldReader) {
                    Stats stats = ((FieldReader)fieldTerms).getStats();
                    long totalTermBytes = stats.totalTermBytes;
                    if (PagedBytesIndexFieldData.this.logger.isTraceEnabled()) {
                        PagedBytesIndexFieldData.this.logger.trace("totalTermBytes: {}, terms.size(): {}, terms.getSumDocFreq(): {}", (Object)totalTermBytes, (Object)terms.size(), (Object)terms.getSumDocFreq());
                    }
                    long totalBytes = totalTermBytes + 2L * terms.size() + 4L * terms.getSumDocFreq();
                    return totalBytes;
                }
            }
            catch (Exception e) {
                PagedBytesIndexFieldData.this.logger.warn("Unable to estimate memory overhead", (Throwable)e);
            }
            return 0L;
        }

        @Override
        public TermsEnum beforeLoad(Terms terms) throws IOException {
            TermsEnum filteredIterator;
            LeafReader reader = this.context.reader();
            TermsEnum iterator = terms.iterator();
            boolean filtered = iterator != (filteredIterator = PagedBytesIndexFieldData.this.filter(terms, iterator, reader));
            iterator = filteredIterator;
            if (filtered) {
                if (PagedBytesIndexFieldData.this.logger.isTraceEnabled()) {
                    PagedBytesIndexFieldData.this.logger.trace("Filter exists, can't circuit break normally, using RamAccountingTermsEnum");
                }
                return new RamAccountingTermsEnum(iterator, this.breaker, this, this.fieldName);
            }
            this.estimatedBytes = this.estimateStringFieldData();
            if (this.estimatedBytes == 0L) {
                iterator = new RamAccountingTermsEnum(iterator, this.breaker, this, this.fieldName);
            } else {
                this.breaker.addEstimateBytesAndMaybeBreak(this.estimatedBytes, this.fieldName);
            }
            return iterator;
        }

        @Override
        public void afterLoad(TermsEnum termsEnum, long actualUsed) {
            if (termsEnum instanceof RamAccountingTermsEnum) {
                this.estimatedBytes = ((RamAccountingTermsEnum)termsEnum).getTotalBytes();
            }
            this.breaker.addWithoutBreaking(-(this.estimatedBytes - actualUsed));
        }
    }

    public static class Builder
    implements IndexFieldData.Builder {
        private final double minFrequency;
        private final double maxFrequency;
        private final int minSegmentSize;

        public Builder(double minFrequency, double maxFrequency, int minSegmentSize) {
            this.minFrequency = minFrequency;
            this.maxFrequency = maxFrequency;
            this.minSegmentSize = minSegmentSize;
        }

        public IndexOrdinalsFieldData build(IndexSettings indexSettings, MappedFieldType fieldType, IndexFieldDataCache cache, CircuitBreakerService breakerService, MapperService mapperService) {
            return new PagedBytesIndexFieldData(indexSettings, fieldType.name(), cache, breakerService, this.minFrequency, this.maxFrequency, this.minSegmentSize);
        }
    }
}

