/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.engine;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.DirectoryReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexCommit;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexWriter;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LeafReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.SegmentReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.store.Directory;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lucene.Lucene;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.concurrent.ReleasableLock;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.engine.EngineConfig;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.engine.EngineException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.engine.ReadOnlyEngine;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.engine.SegmentsStats;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.store.Store;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.translog.Translog;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.translog.TranslogConfig;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.translog.TranslogDeletionPolicy;

public final class NoOpEngine
extends ReadOnlyEngine {
    private final SegmentsStats stats = new SegmentsStats();

    public NoOpEngine(EngineConfig config) {
        super(config, null, null, true, Function.identity());
        Directory directory = this.store.directory();
        try (DirectoryReader reader = DirectoryReader.open(directory, (Map<String, String>)OFF_HEAP_READER_ATTRIBUTES);){
            for (LeafReaderContext ctx : reader.getContext().leaves()) {
                SegmentReader segmentReader = Lucene.segmentReader(ctx.reader());
                this.fillSegmentStats(segmentReader, true, this.stats);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    protected DirectoryReader open(IndexCommit commit) throws IOException {
        Directory directory = commit.getDirectory();
        List<IndexCommit> indexCommits = DirectoryReader.listCommits(directory);
        final IndexCommit indexCommit = indexCommits.get(indexCommits.size() - 1);
        return new DirectoryReader(directory, new LeafReader[0]){

            @Override
            protected DirectoryReader doOpenIfChanged() {
                return null;
            }

            @Override
            protected DirectoryReader doOpenIfChanged(IndexCommit commit) {
                return null;
            }

            @Override
            protected DirectoryReader doOpenIfChanged(IndexWriter writer, boolean applyAllDeletes) {
                return null;
            }

            @Override
            public long getVersion() {
                return 0L;
            }

            @Override
            public boolean isCurrent() {
                return true;
            }

            @Override
            public IndexCommit getIndexCommit() {
                return indexCommit;
            }

            @Override
            protected void doClose() {
            }

            @Override
            public IndexReader.CacheHelper getReaderCacheHelper() {
                return null;
            }
        };
    }

    @Override
    public SegmentsStats segmentsStats(boolean includeSegmentFileSizes, boolean includeUnloadedSegments) {
        if (includeUnloadedSegments) {
            SegmentsStats stats = new SegmentsStats();
            stats.add(this.stats);
            if (!includeSegmentFileSizes) {
                stats.clearFileSizes();
            }
            return stats;
        }
        return super.segmentsStats(includeSegmentFileSizes, includeUnloadedSegments);
    }

    @Override
    public void trimUnreferencedTranslogFiles() {
        block20: {
            Store store = this.engineConfig.getStore();
            store.incRef();
            try (ReleasableLock lock = this.readLock.acquire();){
                this.ensureOpen();
                List<IndexCommit> commits = DirectoryReader.listCommits(store.directory());
                if (commits.size() != 1) break block20;
                Map<String, String> commitUserData = this.getLastCommittedSegmentInfos().getUserData();
                String translogUuid = commitUserData.get("translog_uuid");
                if (translogUuid == null) {
                    throw new IllegalStateException("commit doesn't contain translog unique id");
                }
                if (!commitUserData.containsKey("translog_generation")) {
                    throw new IllegalStateException("commit doesn't contain translog generation id");
                }
                long lastCommitGeneration = Long.parseLong(commitUserData.get("translog_generation"));
                TranslogConfig translogConfig = this.engineConfig.getTranslogConfig();
                long minTranslogGeneration = Translog.readMinTranslogGeneration(translogConfig.getTranslogPath(), translogUuid);
                if (minTranslogGeneration >= lastCommitGeneration) break block20;
                TranslogDeletionPolicy translogDeletionPolicy = new TranslogDeletionPolicy(-1L, -1L);
                translogDeletionPolicy.setTranslogGenerationOfLastCommit(lastCommitGeneration);
                translogDeletionPolicy.setMinTranslogGenerationForRecovery(lastCommitGeneration);
                try (Translog translog = new Translog(translogConfig, translogUuid, translogDeletionPolicy, this.engineConfig.getGlobalCheckpointSupplier(), this.engineConfig.getPrimaryTermSupplier(), seqNo -> {});){
                    translog.trimUnreferencedReaders();
                    this.translogStats = translog.stats();
                }
            }
            catch (Exception e) {
                try {
                    this.failEngine("translog trimming failed", e);
                }
                catch (Exception inner) {
                    e.addSuppressed(inner);
                }
                throw new EngineException(this.shardId, "failed to trim translog", e, new Object[0]);
            }
            finally {
                store.decRef();
            }
        }
    }
}

