/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.codec;

import org.apache.flink.elasticsearch7.shaded.org.apache.logging.log4j.Logger;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.Codec;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.PostingsFormat;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.lucene50.Lucene50StoredFieldsFormat;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.codecs.lucene80.Lucene80Codec;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.CompletionFieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MappedFieldType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MapperService;

public class PerFieldMappingPostingFormatCodec
extends Lucene80Codec {
    private final Logger logger;
    private final MapperService mapperService;
    static final /* synthetic */ boolean $assertionsDisabled;

    public PerFieldMappingPostingFormatCodec(Lucene50StoredFieldsFormat.Mode compressionMode, MapperService mapperService, Logger logger) {
        super(compressionMode);
        this.mapperService = mapperService;
        this.logger = logger;
    }

    @Override
    public PostingsFormat getPostingsFormatForField(String field) {
        MappedFieldType fieldType = this.mapperService.fullName(field);
        if (fieldType == null) {
            this.logger.warn("no index mapper found for field: [{}] returning default postings format", (Object)field);
        } else if (fieldType instanceof CompletionFieldMapper.CompletionFieldType) {
            return CompletionFieldMapper.CompletionFieldType.postingsFormat();
        }
        return super.getPostingsFormatForField(field);
    }

    static {
        boolean bl = $assertionsDisabled = !PerFieldMappingPostingFormatCodec.class.desiredAssertionStatus();
        if (!$assertionsDisabled && !Codec.forName("Lucene80").getClass().isAssignableFrom(PerFieldMappingPostingFormatCodec.class)) {
            throw new AssertionError((Object)"PerFieldMappingPostingFormatCodec must subclass the latest lucene codec: Lucene80");
        }
    }
}

