/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.flink.elasticsearch7.shaded.org.apache.logging.log4j.Logger;
import org.apache.flink.elasticsearch7.shaded.org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.ShardRouting;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.logging.Loggers;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.Index;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.IndexService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.IndexSettings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.shard.IndexEventListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.shard.IndexShard;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.shard.IndexShardState;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.shard.ShardId;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.indices.cluster.IndicesClusterStateService;

final class CompositeIndexEventListener
implements IndexEventListener {
    private final List<IndexEventListener> listeners;
    private final Logger logger;

    CompositeIndexEventListener(IndexSettings indexSettings, Collection<IndexEventListener> listeners) {
        for (IndexEventListener listener : listeners) {
            if (listener != null) continue;
            throw new IllegalArgumentException("listeners must be non-null");
        }
        this.listeners = Collections.unmodifiableList(new ArrayList<IndexEventListener>(listeners));
        this.logger = Loggers.getLogger(this.getClass(), indexSettings.getIndex(), new String[0]);
    }

    @Override
    public void shardRoutingChanged(IndexShard indexShard, @Nullable ShardRouting oldRouting, ShardRouting newRouting) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.shardRoutingChanged(indexShard, oldRouting, newRouting);
            }
            catch (Exception e) {
                this.logger.warn(() -> new ParameterizedMessage("[{}] failed to invoke shard touring changed callback", (Object)indexShard.shardId().getId()), (Throwable)e);
            }
        }
    }

    @Override
    public void afterIndexShardCreated(IndexShard indexShard) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.afterIndexShardCreated(indexShard);
            }
            catch (Exception e) {
                this.logger.warn(() -> new ParameterizedMessage("[{}] failed to invoke after shard created callback", (Object)indexShard.shardId().getId()), (Throwable)e);
                throw e;
            }
        }
    }

    @Override
    public void afterIndexShardStarted(IndexShard indexShard) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.afterIndexShardStarted(indexShard);
            }
            catch (Exception e) {
                this.logger.warn(() -> new ParameterizedMessage("[{}] failed to invoke after shard started callback", (Object)indexShard.shardId().getId()), (Throwable)e);
                throw e;
            }
        }
    }

    @Override
    public void beforeIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard, Settings indexSettings) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.beforeIndexShardClosed(shardId, indexShard, indexSettings);
            }
            catch (Exception e) {
                this.logger.warn(() -> new ParameterizedMessage("[{}] failed to invoke before shard closed callback", (Object)shardId.getId()), (Throwable)e);
                throw e;
            }
        }
    }

    @Override
    public void afterIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard, Settings indexSettings) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.afterIndexShardClosed(shardId, indexShard, indexSettings);
            }
            catch (Exception e) {
                this.logger.warn(() -> new ParameterizedMessage("[{}] failed to invoke after shard closed callback", (Object)shardId.getId()), (Throwable)e);
                throw e;
            }
        }
    }

    @Override
    public void onShardInactive(IndexShard indexShard) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.onShardInactive(indexShard);
            }
            catch (Exception e) {
                this.logger.warn(() -> new ParameterizedMessage("[{}] failed to invoke on shard inactive callback", (Object)indexShard.shardId().getId()), (Throwable)e);
                throw e;
            }
        }
    }

    @Override
    public void indexShardStateChanged(IndexShard indexShard, @Nullable IndexShardState previousState, IndexShardState currentState, @Nullable String reason) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.indexShardStateChanged(indexShard, previousState, indexShard.state(), reason);
            }
            catch (Exception e) {
                this.logger.warn(() -> new ParameterizedMessage("[{}] failed to invoke index shard state changed callback", (Object)indexShard.shardId().getId()), (Throwable)e);
                throw e;
            }
        }
    }

    @Override
    public void beforeIndexCreated(Index index, Settings indexSettings) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.beforeIndexCreated(index, indexSettings);
            }
            catch (Exception e) {
                this.logger.warn("failed to invoke before index created callback", (Throwable)e);
                throw e;
            }
        }
    }

    @Override
    public void afterIndexCreated(IndexService indexService) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.afterIndexCreated(indexService);
            }
            catch (Exception e) {
                this.logger.warn("failed to invoke after index created callback", (Throwable)e);
                throw e;
            }
        }
    }

    @Override
    public void beforeIndexShardCreated(ShardId shardId, Settings indexSettings) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.beforeIndexShardCreated(shardId, indexSettings);
            }
            catch (Exception e) {
                this.logger.warn(() -> new ParameterizedMessage("[{}] failed to invoke before shard created callback", (Object)shardId), (Throwable)e);
                throw e;
            }
        }
    }

    @Override
    public void beforeIndexRemoved(IndexService indexService, IndicesClusterStateService.AllocatedIndices.IndexRemovalReason reason) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.beforeIndexRemoved(indexService, reason);
            }
            catch (Exception e) {
                this.logger.warn("failed to invoke before index removed callback", (Throwable)e);
                throw e;
            }
        }
    }

    @Override
    public void afterIndexRemoved(Index index, IndexSettings indexSettings, IndicesClusterStateService.AllocatedIndices.IndexRemovalReason reason) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.afterIndexRemoved(index, indexSettings, reason);
            }
            catch (Exception e) {
                this.logger.warn("failed to invoke after index removed callback", (Throwable)e);
                throw e;
            }
        }
    }

    @Override
    public void beforeIndexShardDeleted(ShardId shardId, Settings indexSettings) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.beforeIndexShardDeleted(shardId, indexSettings);
            }
            catch (Exception e) {
                this.logger.warn(() -> new ParameterizedMessage("[{}] failed to invoke before shard deleted callback", (Object)shardId.getId()), (Throwable)e);
                throw e;
            }
        }
    }

    @Override
    public void afterIndexShardDeleted(ShardId shardId, Settings indexSettings) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.afterIndexShardDeleted(shardId, indexSettings);
            }
            catch (Exception e) {
                this.logger.warn(() -> new ParameterizedMessage("[{}] failed to invoke after shard deleted callback", (Object)shardId.getId()), (Throwable)e);
                throw e;
            }
        }
    }

    @Override
    public void beforeIndexAddedToCluster(Index index, Settings indexSettings) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.beforeIndexAddedToCluster(index, indexSettings);
            }
            catch (Exception e) {
                this.logger.warn("failed to invoke before index added to cluster callback", (Throwable)e);
                throw e;
            }
        }
    }

    @Override
    public void onStoreCreated(ShardId shardId) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.onStoreCreated(shardId);
            }
            catch (Exception e) {
                this.logger.warn("failed to invoke on store created", (Throwable)e);
                throw e;
            }
        }
    }

    @Override
    public void onStoreClosed(ShardId shardId) {
        for (IndexEventListener listener : this.listeners) {
            try {
                listener.onStoreClosed(shardId);
            }
            catch (Exception e) {
                this.logger.warn("failed to invoke on store closed", (Throwable)e);
                throw e;
            }
        }
    }
}

