/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.discovery;

import java.util.Collections;
import org.apache.flink.elasticsearch7.shaded.org.apache.logging.log4j.LogManager;
import org.apache.flink.elasticsearch7.shaded.org.apache.logging.log4j.Logger;
import org.apache.flink.elasticsearch7.shaded.org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.node.DiscoveryNode;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Randomness;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.UUIDs;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Setting;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.transport.TransportAddress;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.unit.TimeValue;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.core.internal.io.IOUtils;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.discovery.PeerFinder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.ConnectTransportException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.ConnectionProfile;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.Transport;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportRequestOptions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportService;

public class HandshakingTransportAddressConnector
implements PeerFinder.TransportAddressConnector {
    private static final Logger logger = LogManager.getLogger(HandshakingTransportAddressConnector.class);
    public static final Setting<TimeValue> PROBE_CONNECT_TIMEOUT_SETTING = Setting.timeSetting("discovery.probe.connect_timeout", TimeValue.timeValueMillis(3000L), TimeValue.timeValueMillis(1L), Setting.Property.NodeScope);
    public static final Setting<TimeValue> PROBE_HANDSHAKE_TIMEOUT_SETTING = Setting.timeSetting("discovery.probe.handshake_timeout", TimeValue.timeValueMillis(1000L), TimeValue.timeValueMillis(1L), Setting.Property.NodeScope);
    private final TransportService transportService;
    private final TimeValue probeConnectTimeout;
    private final TimeValue probeHandshakeTimeout;

    public HandshakingTransportAddressConnector(Settings settings, TransportService transportService) {
        this.transportService = transportService;
        this.probeConnectTimeout = PROBE_CONNECT_TIMEOUT_SETTING.get(settings);
        this.probeHandshakeTimeout = PROBE_HANDSHAKE_TIMEOUT_SETTING.get(settings);
    }

    @Override
    public void connectToRemoteMasterNode(final TransportAddress transportAddress, final ActionListener<DiscoveryNode> listener) {
        this.transportService.getThreadPool().generic().execute(new AbstractRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void doRun() throws Exception {
                DiscoveryNode remoteNode;
                DiscoveryNode targetNode = new DiscoveryNode("", transportAddress.toString(), UUIDs.randomBase64UUID(Randomness.get()), transportAddress.address().getHostString(), transportAddress.getAddress(), transportAddress, Collections.emptyMap(), Collections.emptySet(), Version.CURRENT.minimumCompatibilityVersion());
                logger.trace("[{}] opening probe connection", (Object)this);
                Transport.Connection connection = HandshakingTransportAddressConnector.this.transportService.openConnection(targetNode, ConnectionProfile.buildSingleChannelProfile(TransportRequestOptions.Type.REG, HandshakingTransportAddressConnector.this.probeConnectTimeout, HandshakingTransportAddressConnector.this.probeHandshakeTimeout, TimeValue.MINUS_ONE, null));
                logger.trace("[{}] opened probe connection", (Object)this);
                try {
                    remoteNode = HandshakingTransportAddressConnector.this.transportService.handshake(connection, HandshakingTransportAddressConnector.this.probeHandshakeTimeout.millis());
                    logger.trace("[{}] handshake successful: {}", (Object)this, (Object)remoteNode);
                }
                catch (Exception e) {
                    try {
                        logger.warn(new ParameterizedMessage("handshake failed for [{}]", (Object)this), (Throwable)e);
                        listener.onFailure(e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeWhileHandlingException(connection);
                        throw throwable;
                    }
                    IOUtils.closeWhileHandlingException(connection);
                    return;
                }
                IOUtils.closeWhileHandlingException(connection);
                if (remoteNode.equals(HandshakingTransportAddressConnector.this.transportService.getLocalNode())) {
                    listener.onFailure(new ConnectTransportException(remoteNode, "local node found"));
                } else if (!remoteNode.isMasterNode()) {
                    listener.onFailure(new ConnectTransportException(remoteNode, "non-master-eligible node found"));
                } else {
                    HandshakingTransportAddressConnector.this.transportService.connectToNode(remoteNode);
                    logger.trace("[{}] full connection successful: {}", (Object)this, (Object)remoteNode);
                    listener.onResponse(remoteNode);
                }
            }

            @Override
            public void onFailure(Exception e) {
                listener.onFailure(e);
            }

            public String toString() {
                return "connectToRemoteMasterNode[" + transportAddress + "]";
            }
        });
    }
}

