/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent;

import java.util.Optional;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentLocation;

public class XContentParseException
extends IllegalArgumentException {
    private final Optional<XContentLocation> location;

    public XContentParseException(String message) {
        this(null, message);
    }

    public XContentParseException(XContentLocation location, String message) {
        super(message);
        this.location = Optional.ofNullable(location);
    }

    public XContentParseException(XContentLocation location, String message, Exception cause) {
        super(message, cause);
        this.location = Optional.ofNullable(location);
    }

    public int getLineNumber() {
        return this.location.map(l -> l.lineNumber).orElse(-1);
    }

    public int getColumnNumber() {
        return this.location.map(l -> l.columnNumber).orElse(-1);
    }

    @Nullable
    public XContentLocation getLocation() {
        return this.location.orElse(null);
    }

    @Override
    public String getMessage() {
        return this.location.map(l -> "[" + l.toString() + "] ").orElse("") + super.getMessage();
    }
}

