/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.recycler;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.recycler.DequeRecycler;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.recycler.Recycler;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.concurrent.ConcurrentCollections;

public class ConcurrentDequeRecycler<T>
extends DequeRecycler<T> {
    final AtomicInteger size = new AtomicInteger();

    public ConcurrentDequeRecycler(Recycler.C<T> c, int maxSize) {
        super(c, ConcurrentCollections.newDeque(), maxSize);
    }

    @Override
    public Recycler.V<T> obtain() {
        Recycler.V v = super.obtain();
        if (v.isRecycled()) {
            this.size.decrementAndGet();
        }
        return v;
    }

    @Override
    protected boolean beforeRelease() {
        return this.size.incrementAndGet() <= this.maxSize;
    }

    @Override
    protected void afterRelease(boolean recycled) {
        if (!recycled) {
            this.size.decrementAndGet();
        }
    }
}

