/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lucene;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LeafReader;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Assertions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.shard.ShardId;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.shard.ShardUtils;

public final class ShardCoreKeyMap {
    private final Map<IndexReader.CacheKey, ShardId> coreKeyToShard = new ConcurrentHashMap<IndexReader.CacheKey, ShardId>();
    private final Map<String, Set<IndexReader.CacheKey>> indexToCoreKey = new HashMap<String, Set<IndexReader.CacheKey>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(LeafReader reader) {
        ShardId shardId = ShardUtils.extractShardId(reader);
        if (shardId == null) {
            throw new IllegalArgumentException("Could not extract shard id from " + reader);
        }
        IndexReader.CacheHelper cacheHelper = reader.getCoreCacheHelper();
        if (cacheHelper == null) {
            throw new IllegalArgumentException("Reader " + reader + " does not support caching");
        }
        IndexReader.CacheKey coreKey = cacheHelper.getKey();
        if (this.coreKeyToShard.containsKey(coreKey)) {
            return;
        }
        String index = shardId.getIndexName();
        ShardCoreKeyMap shardCoreKeyMap = this;
        synchronized (shardCoreKeyMap) {
            if (!this.coreKeyToShard.containsKey(coreKey)) {
                Set<IndexReader.CacheKey> objects = this.indexToCoreKey.get(index);
                if (objects == null) {
                    objects = new HashSet<IndexReader.CacheKey>();
                    this.indexToCoreKey.put(index, objects);
                }
                boolean added = objects.add(coreKey);
                assert (added);
                IndexReader.ClosedListener listener = ownerCoreCacheKey -> {
                    assert (coreKey == ownerCoreCacheKey);
                    ShardCoreKeyMap shardCoreKeyMap = this;
                    synchronized (shardCoreKeyMap) {
                        this.coreKeyToShard.remove(ownerCoreCacheKey);
                        Set<IndexReader.CacheKey> coreKeys = this.indexToCoreKey.get(index);
                        boolean removed = coreKeys.remove(coreKey);
                        assert (removed);
                        if (coreKeys.isEmpty()) {
                            this.indexToCoreKey.remove(index);
                        }
                    }
                };
                boolean addedListener = false;
                try {
                    cacheHelper.addClosedListener(listener);
                    addedListener = true;
                    ShardId previous = this.coreKeyToShard.put(coreKey, shardId);
                    assert (previous == null);
                }
                finally {
                    if (!addedListener) {
                        try {
                            listener.onClose(coreKey);
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Blow up trying to recover from failure to add listener", e);
                        }
                    }
                }
            }
        }
    }

    public synchronized ShardId getShardId(Object coreKey) {
        return this.coreKeyToShard.get(coreKey);
    }

    public synchronized Set<Object> getCoreKeysForIndex(String index) {
        Set<IndexReader.CacheKey> objects = this.indexToCoreKey.get(index);
        if (objects == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(new HashSet<IndexReader.CacheKey>(objects));
    }

    public synchronized int size() {
        assert (this.assertSize());
        return this.coreKeyToShard.size();
    }

    private synchronized boolean assertSize() {
        if (!Assertions.ENABLED) {
            throw new AssertionError((Object)"only run this if assertions are enabled");
        }
        Collection<Set<IndexReader.CacheKey>> values = this.indexToCoreKey.values();
        int size = 0;
        for (Set<IndexReader.CacheKey> value : values) {
            size += value.size();
        }
        return size == this.coreKeyToShard.size();
    }
}

