/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.collect;

import com.carrotsearch.hppc.IntCollection;
import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.IntLookupContainer;
import com.carrotsearch.hppc.IntObjectAssociativeContainer;
import com.carrotsearch.hppc.IntObjectHashMap;
import com.carrotsearch.hppc.IntObjectMap;
import com.carrotsearch.hppc.ObjectContainer;
import com.carrotsearch.hppc.cursors.IntCursor;
import com.carrotsearch.hppc.cursors.IntObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.predicates.IntObjectPredicate;
import com.carrotsearch.hppc.predicates.IntPredicate;
import com.carrotsearch.hppc.procedures.IntObjectProcedure;
import java.util.Iterator;
import java.util.Map;

public final class ImmutableOpenIntMap<VType>
implements Iterable<IntObjectCursor<VType>> {
    private final IntObjectHashMap<VType> map;
    private static final ImmutableOpenIntMap EMPTY = new ImmutableOpenIntMap(new IntObjectHashMap());

    private ImmutableOpenIntMap(IntObjectHashMap<VType> map) {
        this.map = map;
    }

    public VType get(int key) {
        return (VType)this.map.get(key);
    }

    public boolean containsKey(int key) {
        return this.map.containsKey(key);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Iterator<IntObjectCursor<VType>> iterator() {
        return this.map.iterator();
    }

    public IntLookupContainer keys() {
        return this.map.keys();
    }

    public Iterator<Integer> keysIt() {
        final Iterator iterator = this.map.keys().iterator();
        return new Iterator<Integer>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Integer next() {
                return ((IntCursor)iterator.next()).value;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public ObjectContainer<VType> values() {
        return this.map.values();
    }

    public Iterator<VType> valuesIt() {
        final Iterator iterator = this.map.values().iterator();
        return new Iterator<VType>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public VType next() {
                return ((ObjectCursor)iterator.next()).value;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String toString() {
        return this.map.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableOpenIntMap that = (ImmutableOpenIntMap)o;
        return this.map.equals(that.map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public static <VType> ImmutableOpenIntMap<VType> of() {
        return EMPTY;
    }

    public static <VType> Builder<VType> builder() {
        return new Builder();
    }

    public static <VType> Builder<VType> builder(int size) {
        return new Builder(size);
    }

    public static <VType> Builder<VType> builder(ImmutableOpenIntMap<VType> map) {
        return new Builder<VType>(map);
    }

    public static class Builder<VType>
    implements IntObjectMap<VType> {
        private IntObjectHashMap<VType> map;

        public Builder() {
            this(EMPTY);
        }

        public Builder(int size) {
            this.map = new IntObjectHashMap(size);
        }

        public Builder(ImmutableOpenIntMap<VType> map) {
            this.map = ((ImmutableOpenIntMap)map).map.clone();
        }

        public ImmutableOpenIntMap<VType> build() {
            IntObjectHashMap<VType> map = this.map;
            this.map = null;
            return new ImmutableOpenIntMap(map);
        }

        public Builder<VType> putAll(Map<Integer, VType> map) {
            for (Map.Entry<Integer, VType> entry : map.entrySet()) {
                this.map.put(entry.getKey().intValue(), entry.getValue());
            }
            return this;
        }

        public Builder<VType> fPut(int key, VType value) {
            this.map.put(key, value);
            return this;
        }

        public VType put(int key, VType value) {
            return (VType)this.map.put(key, value);
        }

        public VType get(int key) {
            return (VType)this.map.get(key);
        }

        public VType getOrDefault(int kType, VType vType) {
            return (VType)this.map.getOrDefault(kType, vType);
        }

        public Builder<VType> fRemove(int key) {
            this.map.remove(key);
            return this;
        }

        public VType remove(int key) {
            return (VType)this.map.remove(key);
        }

        public Iterator<IntObjectCursor<VType>> iterator() {
            return this.map.iterator();
        }

        public boolean containsKey(int key) {
            return this.map.containsKey(key);
        }

        public int size() {
            return this.map.size();
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        public void clear() {
            this.map.clear();
        }

        public int putAll(IntObjectAssociativeContainer<? extends VType> container) {
            return this.map.putAll(container);
        }

        public int putAll(Iterable<? extends IntObjectCursor<? extends VType>> iterable) {
            return this.map.putAll(iterable);
        }

        public int removeAll(IntContainer container) {
            return this.map.removeAll(container);
        }

        public int removeAll(IntPredicate predicate) {
            return this.map.removeAll(predicate);
        }

        public <T extends IntObjectProcedure<? super VType>> T forEach(T procedure) {
            return (T)this.map.forEach(procedure);
        }

        public IntCollection keys() {
            return this.map.keys();
        }

        public ObjectContainer<VType> values() {
            return this.map.values();
        }

        public int removeAll(IntObjectPredicate<? super VType> predicate) {
            return this.map.removeAll(predicate);
        }

        public <T extends IntObjectPredicate<? super VType>> T forEach(T predicate) {
            return (T)this.map.forEach(predicate);
        }

        public int indexOf(int key) {
            return this.map.indexOf(key);
        }

        public boolean indexExists(int index) {
            return this.map.indexExists(index);
        }

        public VType indexGet(int index) {
            return (VType)this.map.indexGet(index);
        }

        public VType indexReplace(int index, VType newValue) {
            return (VType)this.map.indexReplace(index, newValue);
        }

        public void indexInsert(int index, int key, VType value) {
            this.map.indexInsert(index, key, value);
        }

        public void release() {
            this.map.release();
        }

        public String visualizeKeyDistribution(int characters) {
            return this.map.visualizeKeyDistribution(characters);
        }
    }
}

