/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.breaker;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ElasticsearchException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.breaker.CircuitBreaker;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestStatus;

public class CircuitBreakingException
extends ElasticsearchException {
    private final long bytesWanted;
    private final long byteLimit;
    private final CircuitBreaker.Durability durability;

    public CircuitBreakingException(StreamInput in) throws IOException {
        super(in);
        this.byteLimit = in.readLong();
        this.bytesWanted = in.readLong();
        this.durability = in.getVersion().onOrAfter(Version.V_7_0_0) ? in.readEnum(CircuitBreaker.Durability.class) : CircuitBreaker.Durability.PERMANENT;
    }

    public CircuitBreakingException(String message, CircuitBreaker.Durability durability) {
        this(message, 0L, 0L, durability);
    }

    public CircuitBreakingException(String message, long bytesWanted, long byteLimit, CircuitBreaker.Durability durability) {
        super(message, new Object[0]);
        this.bytesWanted = bytesWanted;
        this.byteLimit = byteLimit;
        this.durability = durability;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.byteLimit);
        out.writeLong(this.bytesWanted);
        if (out.getVersion().onOrAfter(Version.V_7_0_0)) {
            out.writeEnum(this.durability);
        }
    }

    public long getBytesWanted() {
        return this.bytesWanted;
    }

    public long getByteLimit() {
        return this.byteLimit;
    }

    public CircuitBreaker.Durability getDurability() {
        return this.durability;
    }

    @Override
    public RestStatus status() {
        return RestStatus.TOO_MANY_REQUESTS;
    }

    @Override
    protected void metadataToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field("bytes_wanted", this.bytesWanted);
        builder.field("bytes_limit", this.byteLimit);
        builder.field("durability", (Object)this.durability);
    }
}

