/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.breaker;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.flink.elasticsearch7.shaded.org.apache.logging.log4j.Logger;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.breaker.CircuitBreaker;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.breaker.CircuitBreakingException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.unit.ByteSizeValue;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.indices.breaker.BreakerSettings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.indices.breaker.HierarchyCircuitBreakerService;

public class ChildMemoryCircuitBreaker
implements CircuitBreaker {
    private final long memoryBytesLimit;
    private final double overheadConstant;
    private final CircuitBreaker.Durability durability;
    private final AtomicLong used;
    private final AtomicLong trippedCount;
    private final Logger logger;
    private final HierarchyCircuitBreakerService parent;
    private final String name;

    public ChildMemoryCircuitBreaker(BreakerSettings settings, Logger logger, HierarchyCircuitBreakerService parent, String name) {
        this(settings, null, logger, parent, name);
    }

    public ChildMemoryCircuitBreaker(BreakerSettings settings, ChildMemoryCircuitBreaker oldBreaker, Logger logger, HierarchyCircuitBreakerService parent, String name) {
        this.name = name;
        this.memoryBytesLimit = settings.getLimit();
        this.overheadConstant = settings.getOverhead();
        this.durability = settings.getDurability();
        if (oldBreaker == null) {
            this.used = new AtomicLong(0L);
            this.trippedCount = new AtomicLong(0L);
        } else {
            this.used = oldBreaker.used;
            this.trippedCount = oldBreaker.trippedCount;
        }
        this.logger = logger;
        if (logger.isTraceEnabled()) {
            logger.trace("creating ChildCircuitBreaker with settings {}", (Object)settings);
        }
        this.parent = parent;
    }

    @Override
    public void circuitBreak(String fieldName, long bytesNeeded) {
        this.trippedCount.incrementAndGet();
        String message = "[" + this.name + "] Data too large, data for [" + fieldName + "] would be [" + bytesNeeded + "/" + new ByteSizeValue(bytesNeeded) + "], which is larger than the limit of [" + this.memoryBytesLimit + "/" + new ByteSizeValue(this.memoryBytesLimit) + "]";
        this.logger.debug("{}", (Object)message);
        throw new CircuitBreakingException(message, bytesNeeded, this.memoryBytesLimit, this.durability);
    }

    @Override
    public double addEstimateBytesAndMaybeBreak(long bytes, String label) throws CircuitBreakingException {
        if (this.memoryBytesLimit == 0L) {
            this.circuitBreak(label, bytes);
        }
        long newUsed = this.memoryBytesLimit == -1L ? this.noLimit(bytes, label) : this.limit(bytes, label);
        try {
            this.parent.checkParentLimit((long)((double)bytes * this.overheadConstant), label);
        }
        catch (CircuitBreakingException e) {
            this.addWithoutBreaking(-bytes);
            throw e;
        }
        return newUsed;
    }

    private long noLimit(long bytes, String label) {
        long newUsed = this.used.addAndGet(bytes);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("[{}] Adding [{}][{}] to used bytes [new used: [{}], limit: [-1b]]", (Object)this.name, (Object)new ByteSizeValue(bytes), (Object)label, (Object)new ByteSizeValue(newUsed));
        }
        return newUsed;
    }

    private long limit(long bytes, String label) {
        long newUsed;
        long currentUsed;
        do {
            currentUsed = this.used.get();
            newUsed = currentUsed + bytes;
            long newUsedWithOverhead = (long)((double)newUsed * this.overheadConstant);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("[{}] Adding [{}][{}] to used bytes [new used: [{}], limit: {} [{}], estimate: {} [{}]]", (Object)this.name, (Object)new ByteSizeValue(bytes), (Object)label, (Object)new ByteSizeValue(newUsed), (Object)this.memoryBytesLimit, (Object)new ByteSizeValue(this.memoryBytesLimit), (Object)newUsedWithOverhead, (Object)new ByteSizeValue(newUsedWithOverhead));
            }
            if (this.memoryBytesLimit <= 0L || newUsedWithOverhead <= this.memoryBytesLimit) continue;
            this.logger.warn("[{}] New used memory {} [{}] for data of [{}] would be larger than configured breaker: {} [{}], breaking", (Object)this.name, (Object)newUsedWithOverhead, (Object)new ByteSizeValue(newUsedWithOverhead), (Object)label, (Object)this.memoryBytesLimit, (Object)new ByteSizeValue(this.memoryBytesLimit));
            this.circuitBreak(label, newUsedWithOverhead);
        } while (!this.used.compareAndSet(currentUsed, newUsed));
        return newUsed;
    }

    @Override
    public long addWithoutBreaking(long bytes) {
        long u = this.used.addAndGet(bytes);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("[{}] Adjusted breaker by [{}] bytes, now [{}]", (Object)this.name, (Object)bytes, (Object)u);
        }
        assert (u >= 0L) : "Used bytes: [" + u + "] must be >= 0";
        return u;
    }

    @Override
    public long getUsed() {
        return this.used.get();
    }

    @Override
    public long getLimit() {
        return this.memoryBytesLimit;
    }

    @Override
    public double getOverhead() {
        return this.overheadConstant;
    }

    @Override
    public long getTrippedCount() {
        return this.trippedCount.get();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public CircuitBreaker.Durability getDurability() {
        return this.durability;
    }
}

