/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.blobstore;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.NoSuchFileException;
import java.util.List;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.blobstore.BlobMetaData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.blobstore.BlobPath;

public interface BlobContainer {
    public BlobPath path();

    public boolean blobExists(String var1);

    public InputStream readBlob(String var1) throws IOException;

    public void writeBlob(String var1, InputStream var2, long var3, boolean var5) throws IOException;

    public void writeBlobAtomic(String var1, InputStream var2, long var3, boolean var5) throws IOException;

    public void deleteBlob(String var1) throws IOException;

    default public void deleteBlobsIgnoringIfNotExists(List<String> blobNames) throws IOException {
        IOException ioe = null;
        for (String blobName : blobNames) {
            try {
                this.deleteBlobIgnoringIfNotExists(blobName);
            }
            catch (IOException e) {
                if (ioe == null) {
                    ioe = e;
                    continue;
                }
                ioe.addSuppressed(e);
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    default public void deleteBlobIgnoringIfNotExists(String blobName) throws IOException {
        try {
            this.deleteBlob(blobName);
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
    }

    public Map<String, BlobMetaData> listBlobs() throws IOException;

    public Map<String, BlobContainer> children() throws IOException;

    public Map<String, BlobMetaData> listBlobsByPrefix(String var1) throws IOException;
}

