/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing;

public enum Preference {
    SHARDS("_shards"),
    PREFER_NODES("_prefer_nodes"),
    LOCAL("_local"),
    ONLY_LOCAL("_only_local"),
    ONLY_NODES("_only_nodes");

    private final String type;

    private Preference(String type) {
        this.type = type;
    }

    public String type() {
        return this.type;
    }

    public static Preference parse(String preference) {
        int colonIndex = preference.indexOf(58);
        String preferenceType = colonIndex == -1 ? preference : preference.substring(0, colonIndex);
        switch (preferenceType) {
            case "_shards": {
                return SHARDS;
            }
            case "_prefer_nodes": {
                return PREFER_NODES;
            }
            case "_local": {
                return LOCAL;
            }
            case "_only_local": 
            case "_onlyLocal": {
                return ONLY_LOCAL;
            }
            case "_only_nodes": {
                return ONLY_NODES;
            }
        }
        throw new IllegalArgumentException("no Preference for [" + preferenceType + "]");
    }
}

