/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.ShardRouting;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.ShardsIterator;

public class PlainShardsIterator
implements ShardsIterator {
    private final List<ShardRouting> shards;
    private volatile int index;

    public PlainShardsIterator(List<ShardRouting> shards) {
        this.shards = shards;
        this.reset();
    }

    @Override
    public void reset() {
        this.index = 0;
    }

    @Override
    public int remaining() {
        return this.shards.size() - this.index;
    }

    @Override
    public ShardRouting nextOrNull() {
        if (this.index == this.shards.size()) {
            return null;
        }
        return this.shards.get(this.index++);
    }

    @Override
    public int size() {
        return this.shards.size();
    }

    @Override
    public int sizeActive() {
        int count = 0;
        for (ShardRouting shard : this.shards) {
            if (!shard.active()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public List<ShardRouting> getShardRoutings() {
        return Collections.unmodifiableList(this.shards);
    }

    @Override
    public Iterator<ShardRouting> iterator() {
        return this.shards.iterator();
    }
}

