/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.coordination;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.node.DiscoveryNode;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.TransportResponse;

public class PeersResponse
extends TransportResponse {
    private final Optional<DiscoveryNode> masterNode;
    private final List<DiscoveryNode> knownPeers;
    private final long term;

    public PeersResponse(Optional<DiscoveryNode> masterNode, List<DiscoveryNode> knownPeers, long term) {
        assert (!masterNode.isPresent() || knownPeers.isEmpty());
        this.masterNode = masterNode;
        this.knownPeers = knownPeers;
        this.term = term;
    }

    public PeersResponse(StreamInput in) throws IOException {
        this.masterNode = Optional.ofNullable(in.readOptionalWriteable(DiscoveryNode::new));
        this.knownPeers = in.readList(DiscoveryNode::new);
        this.term = in.readLong();
        assert (!this.masterNode.isPresent() || this.knownPeers.isEmpty());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalWriteable(this.masterNode.orElse(null));
        out.writeList(this.knownPeers);
        out.writeLong(this.term);
    }

    public Optional<DiscoveryNode> getMasterNode() {
        return this.masterNode;
    }

    public List<DiscoveryNode> getKnownPeers() {
        return this.knownPeers;
    }

    public long getTerm() {
        return this.term;
    }

    public String toString() {
        return "PeersResponse{masterNode=" + this.masterNode + ", knownPeers=" + this.knownPeers + ", term=" + this.term + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PeersResponse that = (PeersResponse)o;
        return this.term == that.term && Objects.equals(this.masterNode, that.masterNode) && Objects.equals(this.knownPeers, that.knownPeers);
    }

    public int hashCode() {
        return Objects.hash(this.masterNode, this.knownPeers, this.term);
    }
}

