/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.coordination;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.flink.elasticsearch7.shaded.org.apache.logging.log4j.Logger;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.ClusterState;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.NotMasterException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.block.ClusterBlocks;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.IndexMetaData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.metadata.MetaData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.node.DiscoveryNode;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.node.DiscoveryNodes;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.RerouteService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.discovery.zen.ElectMasterService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.gateway.GatewayService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.persistent.PersistentTasksCustomMetaData;

public class JoinTaskExecutor
implements ClusterStateTaskExecutor<Task> {
    private final AllocationService allocationService;
    private final Logger logger;
    private final RerouteService rerouteService;
    private final int minimumMasterNodesOnLocalNode;

    public JoinTaskExecutor(Settings settings, AllocationService allocationService, Logger logger, RerouteService rerouteService) {
        this.allocationService = allocationService;
        this.logger = logger;
        this.minimumMasterNodesOnLocalNode = ElectMasterService.DISCOVERY_ZEN_MINIMUM_MASTER_NODES_SETTING.get(settings);
        this.rerouteService = rerouteService;
    }

    @Override
    public ClusterStateTaskExecutor.ClusterTasksResult<Task> execute(ClusterState currentState, List<Task> joiningNodes) throws Exception {
        ClusterState.Builder newState;
        ClusterStateTaskExecutor.ClusterTasksResult.Builder<Task> results = ClusterStateTaskExecutor.ClusterTasksResult.builder();
        DiscoveryNodes currentNodes = currentState.nodes();
        boolean nodesChanged = false;
        if (joiningNodes.size() == 1 && joiningNodes.get(0).isFinishElectionTask()) {
            return results.successes(joiningNodes).build(currentState);
        }
        if (currentNodes.getMasterNode() == null && joiningNodes.stream().anyMatch(Task::isBecomeMasterTask)) {
            assert (joiningNodes.stream().anyMatch(Task::isFinishElectionTask)) : "becoming a master but election is not finished " + joiningNodes;
            newState = this.becomeMasterAndTrimConflictingNodes(currentState, joiningNodes);
            nodesChanged = true;
        } else {
            if (!currentNodes.isLocalNodeElectedMaster()) {
                this.logger.trace("processing node joins, but we are not the master. current master: {}", (Object)currentNodes.getMasterNode());
                throw new NotMasterException("Node [" + currentNodes.getLocalNode() + "] not master for join request");
            }
            newState = ClusterState.builder(currentState);
        }
        DiscoveryNodes.Builder nodesBuilder = DiscoveryNodes.builder(newState.nodes());
        assert (nodesBuilder.isLocalNodeElectedMaster());
        Version minClusterNodeVersion = newState.nodes().getMinNodeVersion();
        Version maxClusterNodeVersion = newState.nodes().getMaxNodeVersion();
        boolean enforceMajorVersion = !currentState.getBlocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK);
        for (Task joinTask : joiningNodes) {
            if (!joinTask.isBecomeMasterTask() && !joinTask.isFinishElectionTask()) {
                if (currentNodes.nodeExists(joinTask.node())) {
                    this.logger.debug("received a join request for an existing node [{}]", (Object)joinTask.node());
                } else {
                    DiscoveryNode node = joinTask.node();
                    try {
                        if (enforceMajorVersion) {
                            JoinTaskExecutor.ensureMajorVersionBarrier(node.getVersion(), minClusterNodeVersion);
                        }
                        JoinTaskExecutor.ensureNodesCompatibility(node.getVersion(), minClusterNodeVersion, maxClusterNodeVersion);
                        JoinTaskExecutor.ensureIndexCompatibility(node.getVersion(), currentState.getMetaData());
                        nodesBuilder.add(node);
                        nodesChanged = true;
                        minClusterNodeVersion = Version.min(minClusterNodeVersion, node.getVersion());
                        maxClusterNodeVersion = Version.max(maxClusterNodeVersion, node.getVersion());
                    }
                    catch (IllegalArgumentException | IllegalStateException e2) {
                        results.failure(joinTask, e2);
                        continue;
                    }
                }
            }
            results.success(joinTask);
        }
        if (nodesChanged) {
            this.rerouteService.reroute("post-join reroute", ActionListener.wrap(r -> this.logger.trace("post-join reroute completed"), e -> this.logger.debug("post-join reroute failed", (Throwable)e)));
            return results.build(this.allocationService.adaptAutoExpandReplicas(newState.nodes(nodesBuilder).build()));
        }
        return results.build(newState.build());
    }

    protected ClusterState.Builder becomeMasterAndTrimConflictingNodes(ClusterState currentState, List<Task> joiningNodes) {
        assert (currentState.nodes().getMasterNodeId() == null) : currentState;
        DiscoveryNodes currentNodes = currentState.nodes();
        DiscoveryNodes.Builder nodesBuilder = DiscoveryNodes.builder(currentNodes);
        nodesBuilder.masterNodeId(currentState.nodes().getLocalNodeId());
        for (Task joinTask : joiningNodes) {
            DiscoveryNode nodeWithSameAddress;
            if (joinTask.isBecomeMasterTask() || joinTask.isFinishElectionTask()) continue;
            DiscoveryNode joiningNode = joinTask.node();
            DiscoveryNode nodeWithSameId = nodesBuilder.get(joiningNode.getId());
            if (nodeWithSameId != null && !nodeWithSameId.equals(joiningNode)) {
                this.logger.debug("removing existing node [{}], which conflicts with incoming join from [{}]", (Object)nodeWithSameId, (Object)joiningNode);
                nodesBuilder.remove(nodeWithSameId.getId());
            }
            if ((nodeWithSameAddress = currentNodes.findByAddress(joiningNode.getAddress())) == null || nodeWithSameAddress.equals(joiningNode)) continue;
            this.logger.debug("removing existing node [{}], which conflicts with incoming join from [{}]", (Object)nodeWithSameAddress, (Object)joiningNode);
            nodesBuilder.remove(nodeWithSameAddress.getId());
        }
        ClusterState tmpState = ClusterState.builder(currentState).nodes(nodesBuilder).blocks(ClusterBlocks.builder().blocks(currentState.blocks()).removeGlobalBlock(2)).minimumMasterNodesOnPublishingMaster(this.minimumMasterNodesOnLocalNode).build();
        this.logger.trace("becomeMasterAndTrimConflictingNodes: {}", (Object)tmpState.nodes());
        this.allocationService.cleanCaches();
        tmpState = PersistentTasksCustomMetaData.disassociateDeadNodes(tmpState);
        return ClusterState.builder(this.allocationService.disassociateDeadNodes(tmpState, false, "removed dead nodes on election"));
    }

    @Override
    public boolean runOnlyOnMaster() {
        return false;
    }

    public static Task newBecomeMasterTask() {
        return new Task(null, "_BECOME_MASTER_TASK_");
    }

    public static Task newFinishElectionTask() {
        return new Task(null, "_FINISH_ELECTION_");
    }

    public static void ensureIndexCompatibility(Version nodeVersion, MetaData metaData) {
        Version supportedIndexVersion = nodeVersion.minimumIndexCompatibilityVersion();
        for (IndexMetaData idxMetaData : metaData) {
            if (idxMetaData.getCreationVersion().after(nodeVersion)) {
                throw new IllegalStateException("index " + idxMetaData.getIndex() + " version not supported: " + idxMetaData.getCreationVersion() + " the node version is: " + nodeVersion);
            }
            if (!idxMetaData.getCreationVersion().before(supportedIndexVersion)) continue;
            throw new IllegalStateException("index " + idxMetaData.getIndex() + " version not supported: " + idxMetaData.getCreationVersion() + " minimum compatible index version is: " + supportedIndexVersion);
        }
    }

    public static void ensureNodesCompatibility(Version joiningNodeVersion, DiscoveryNodes currentNodes) {
        Version minNodeVersion = currentNodes.getMinNodeVersion();
        Version maxNodeVersion = currentNodes.getMaxNodeVersion();
        JoinTaskExecutor.ensureNodesCompatibility(joiningNodeVersion, minNodeVersion, maxNodeVersion);
    }

    public static void ensureNodesCompatibility(Version joiningNodeVersion, Version minClusterNodeVersion, Version maxClusterNodeVersion) {
        assert (minClusterNodeVersion.onOrBefore(maxClusterNodeVersion)) : minClusterNodeVersion + " > " + maxClusterNodeVersion;
        if (!joiningNodeVersion.isCompatible(maxClusterNodeVersion)) {
            throw new IllegalStateException("node version [" + joiningNodeVersion + "] is not supported. The cluster contains nodes with version [" + maxClusterNodeVersion + "], which is incompatible.");
        }
        if (!joiningNodeVersion.isCompatible(minClusterNodeVersion)) {
            throw new IllegalStateException("node version [" + joiningNodeVersion + "] is not supported.The cluster contains nodes with version [" + minClusterNodeVersion + "], which is incompatible.");
        }
    }

    public static void ensureMajorVersionBarrier(Version joiningNodeVersion, Version minClusterNodeVersion) {
        byte clusterMajor = minClusterNodeVersion.major;
        if (joiningNodeVersion.major < clusterMajor) {
            throw new IllegalStateException("node version [" + joiningNodeVersion + "] is not supported. All nodes in the cluster are of a higher major [" + clusterMajor + "].");
        }
    }

    public static Collection<BiConsumer<DiscoveryNode, ClusterState>> addBuiltInJoinValidators(Collection<BiConsumer<DiscoveryNode, ClusterState>> onJoinValidators) {
        ArrayList<BiConsumer<DiscoveryNode, ClusterState>> validators = new ArrayList<BiConsumer<DiscoveryNode, ClusterState>>();
        validators.add((node, state) -> {
            JoinTaskExecutor.ensureNodesCompatibility(node.getVersion(), state.getNodes());
            JoinTaskExecutor.ensureIndexCompatibility(node.getVersion(), state.getMetaData());
        });
        validators.addAll(onJoinValidators);
        return Collections.unmodifiableCollection(validators);
    }

    public static class Task {
        private final DiscoveryNode node;
        private final String reason;
        private static final String BECOME_MASTER_TASK_REASON = "_BECOME_MASTER_TASK_";
        private static final String FINISH_ELECTION_TASK_REASON = "_FINISH_ELECTION_";

        public Task(DiscoveryNode node, String reason) {
            this.node = node;
            this.reason = reason;
        }

        public DiscoveryNode node() {
            return this.node;
        }

        public String reason() {
            return this.reason;
        }

        public String toString() {
            return this.node != null ? this.node + " " + this.reason : this.reason;
        }

        public boolean isBecomeMasterTask() {
            return this.reason.equals(BECOME_MASTER_TASK_REASON);
        }

        public boolean isFinishElectionTask() {
            return this.reason.equals(FINISH_ELECTION_TASK_REASON);
        }
    }
}

