/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.rollup.job.config;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.Validatable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ValidationException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.unit.TimeValue;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;

public class DateHistogramGroupConfig
implements Validatable,
ToXContentObject {
    static final String NAME = "date_histogram";
    private static final String INTERVAL = "interval";
    private static final String FIELD = "field";
    private static final String TIME_ZONE = "time_zone";
    private static final String DELAY = "delay";
    private static final String DEFAULT_TIMEZONE = "UTC";
    private static final String CALENDAR_INTERVAL = "calendar_interval";
    private static final String FIXED_INTERVAL = "fixed_interval";
    private static final Set<String> DATE_FIELD_UNITS;
    private static final ConstructingObjectParser<DateHistogramGroupConfig, Void> PARSER;
    private final String field;
    private final DateHistogramInterval interval;
    private final DateHistogramInterval delay;
    private final String timeZone;

    @Deprecated
    public DateHistogramGroupConfig(String field, DateHistogramInterval interval) {
        this(field, interval, null, null);
    }

    @Deprecated
    public DateHistogramGroupConfig(String field, DateHistogramInterval interval, @Nullable DateHistogramInterval delay, @Nullable String timeZone) {
        this.field = field;
        this.interval = interval;
        this.delay = delay;
        this.timeZone = timeZone != null && !timeZone.isEmpty() ? timeZone : DEFAULT_TIMEZONE;
    }

    @Override
    public Optional<ValidationException> validate() {
        ValidationException validationException = new ValidationException();
        if (this.field == null || this.field.isEmpty()) {
            validationException.addValidationError("Field name is required");
        }
        if (this.interval == null) {
            validationException.addValidationError("Interval is required");
        }
        if (validationException.validationErrors().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(validationException);
    }

    public String getField() {
        return this.field;
    }

    public DateHistogramInterval getInterval() {
        return this.interval;
    }

    public DateHistogramInterval getDelay() {
        return this.delay;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.getClass().equals(CalendarInterval.class)) {
            builder.field(CALENDAR_INTERVAL, this.interval.toString());
        } else if (this.getClass().equals(FixedInterval.class)) {
            builder.field(FIXED_INTERVAL, this.interval.toString());
        } else {
            builder.field(INTERVAL, this.interval.toString());
        }
        builder.field(FIELD, this.field);
        if (this.delay != null) {
            builder.field(DELAY, this.delay.toString());
        }
        builder.field(TIME_ZONE, this.timeZone);
        return builder.endObject();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DateHistogramGroupConfig that = (DateHistogramGroupConfig)other;
        return Objects.equals(this.interval, that.interval) && Objects.equals(this.field, that.field) && Objects.equals(this.delay, that.delay) && Objects.equals(this.timeZone, that.timeZone);
    }

    public int hashCode() {
        return Objects.hash(this.interval, this.field, this.delay, this.timeZone);
    }

    public static DateHistogramGroupConfig fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    static {
        HashSet<String> dateFieldUnits = new HashSet<String>();
        dateFieldUnits.add("year");
        dateFieldUnits.add("1y");
        dateFieldUnits.add("quarter");
        dateFieldUnits.add("1q");
        dateFieldUnits.add("month");
        dateFieldUnits.add("1M");
        dateFieldUnits.add("week");
        dateFieldUnits.add("1w");
        dateFieldUnits.add("day");
        dateFieldUnits.add("1d");
        dateFieldUnits.add("hour");
        dateFieldUnits.add("1h");
        dateFieldUnits.add("minute");
        dateFieldUnits.add("1m");
        dateFieldUnits.add("second");
        dateFieldUnits.add("1s");
        DATE_FIELD_UNITS = Collections.unmodifiableSet(dateFieldUnits);
        PARSER = new ConstructingObjectParser(NAME, true, a -> {
            DateHistogramInterval oldInterval = (DateHistogramInterval)a[1];
            DateHistogramInterval calendarInterval = (DateHistogramInterval)a[2];
            DateHistogramInterval fixedInterval = (DateHistogramInterval)a[3];
            if (oldInterval != null) {
                if (calendarInterval != null || fixedInterval != null) {
                    throw new IllegalArgumentException("Cannot use [interval] with [fixed_interval] or [calendar_interval] configuration options.");
                }
                return new DateHistogramGroupConfig((String)a[0], oldInterval, (DateHistogramInterval)a[4], (String)a[5]);
            }
            if (calendarInterval != null && fixedInterval == null) {
                return new CalendarInterval((String)a[0], calendarInterval, (DateHistogramInterval)a[4], (String)a[5]);
            }
            if (calendarInterval == null && fixedInterval != null) {
                return new FixedInterval((String)a[0], fixedInterval, (DateHistogramInterval)a[4], (String)a[5]);
            }
            if (calendarInterval != null && fixedInterval != null) {
                throw new IllegalArgumentException("Cannot set both [fixed_interval] and [calendar_interval] at the same time");
            }
            throw new IllegalArgumentException("An interval is required.  Use [fixed_interval] or [calendar_interval].");
        });
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(FIELD, new String[0]));
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> new DateHistogramInterval(p.text()), new ParseField(INTERVAL, new String[0]), ObjectParser.ValueType.STRING);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> new DateHistogramInterval(p.text()), new ParseField(CALENDAR_INTERVAL, new String[0]), ObjectParser.ValueType.STRING);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> new DateHistogramInterval(p.text()), new ParseField(FIXED_INTERVAL, new String[0]), ObjectParser.ValueType.STRING);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> new DateHistogramInterval(p.text()), new ParseField(DELAY, new String[0]), ObjectParser.ValueType.STRING);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField(TIME_ZONE, new String[0]));
    }

    public static class CalendarInterval
    extends DateHistogramGroupConfig {
        public CalendarInterval(String field, DateHistogramInterval interval) {
            this(field, interval, null, null);
        }

        public CalendarInterval(String field, DateHistogramInterval interval, DateHistogramInterval delay, String timeZone) {
            super(field, interval, delay, timeZone);
            if (!DATE_FIELD_UNITS.contains(interval.toString())) {
                throw new IllegalArgumentException("The supplied interval [" + interval + "] could not be parsed as a calendar interval.");
            }
        }
    }

    public static class FixedInterval
    extends DateHistogramGroupConfig {
        public FixedInterval(String field, DateHistogramInterval interval) {
            this(field, interval, null, null);
        }

        public FixedInterval(String field, DateHistogramInterval interval, DateHistogramInterval delay, String timeZone) {
            super(field, interval, delay, timeZone);
            TimeValue.parseTimeValue(interval.toString(), "date_histogram.FixedInterval");
        }
    }
}

