/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.rollup;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.collect.Tuple;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentFragment;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;

public class RollupJobCaps
implements ToXContentObject {
    private static final ParseField JOB_ID = new ParseField("job_id", new String[0]);
    private static final ParseField ROLLUP_INDEX = new ParseField("rollup_index", new String[0]);
    private static final ParseField INDEX_PATTERN = new ParseField("index_pattern", new String[0]);
    private static final ParseField FIELDS = new ParseField("fields", new String[0]);
    private static final String NAME = "rollup_job_caps";
    public static final ConstructingObjectParser<RollupJobCaps, Void> PARSER = new ConstructingObjectParser("rollup_job_caps", true, a -> {
        List caps = (List)a[3];
        HashMap<String, RollupFieldCaps> mapCaps = new HashMap<String, RollupFieldCaps>(caps.stream().collect(Collectors.toMap(Tuple::v1, Tuple::v2)));
        return new RollupJobCaps((String)a[0], (String)a[1], (String)a[2], mapCaps);
    });
    private final String jobID;
    private final String rollupIndex;
    private final String indexPattern;
    private final Map<String, RollupFieldCaps> fieldCapLookup;

    RollupJobCaps(String jobID, String rollupIndex, String indexPattern, Map<String, RollupFieldCaps> fieldCapLookup) {
        this.jobID = jobID;
        this.rollupIndex = rollupIndex;
        this.indexPattern = indexPattern;
        this.fieldCapLookup = Collections.unmodifiableMap(Objects.requireNonNull(fieldCapLookup));
    }

    public Map<String, RollupFieldCaps> getFieldCaps() {
        return this.fieldCapLookup;
    }

    public String getRollupIndex() {
        return this.rollupIndex;
    }

    public String getIndexPattern() {
        return this.indexPattern;
    }

    public String getJobID() {
        return this.jobID;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(JOB_ID.getPreferredName(), this.jobID);
        builder.field(ROLLUP_INDEX.getPreferredName(), this.rollupIndex);
        builder.field(INDEX_PATTERN.getPreferredName(), this.indexPattern);
        builder.startObject(FIELDS.getPreferredName());
        for (Map.Entry<String, RollupFieldCaps> fieldCap : this.fieldCapLookup.entrySet()) {
            builder.array(fieldCap.getKey(), fieldCap.getValue());
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        RollupJobCaps that = (RollupJobCaps)other;
        return Objects.equals(this.jobID, that.jobID) && Objects.equals(this.indexPattern, that.indexPattern) && Objects.equals(this.rollupIndex, that.rollupIndex) && Objects.equals(this.fieldCapLookup, that.fieldCapLookup);
    }

    public int hashCode() {
        return Objects.hash(this.jobID, this.rollupIndex, this.fieldCapLookup, this.indexPattern);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), JOB_ID);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), ROLLUP_INDEX);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), INDEX_PATTERN);
        PARSER.declareNamedObjects(ConstructingObjectParser.constructorArg(), (p, c, name) -> new Tuple<String, RollupFieldCaps>(name, RollupFieldCaps.fromXContent(p)), FIELDS);
    }

    public static class RollupFieldCaps
    implements ToXContentFragment {
        private static final String NAME = "rollup_field_caps";
        private final List<Map<String, Object>> aggs;

        RollupFieldCaps(List<Map<String, Object>> aggs) {
            this.aggs = Collections.unmodifiableList(Objects.requireNonNull(aggs));
        }

        public List<Map<String, Object>> getAggs() {
            return this.aggs;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            for (Map<String, Object> agg : this.aggs) {
                builder.map(agg);
            }
            return builder;
        }

        public static RollupFieldCaps fromXContent(XContentParser parser) throws IOException {
            ArrayList<Map<String, Object>> aggs = new ArrayList<Map<String, Object>>();
            if (parser.nextToken().equals((Object)XContentParser.Token.START_ARRAY)) {
                while (parser.nextToken().equals((Object)XContentParser.Token.START_OBJECT)) {
                    aggs.add(parser.map());
                }
            }
            return new RollupFieldCaps(aggs);
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            RollupFieldCaps that = (RollupFieldCaps)other;
            return Objects.equals(this.aggs, that.aggs);
        }

        public int hashCode() {
            return Objects.hash(this.aggs);
        }
    }
}

