/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.dataframe;

import java.io.IOException;
import java.time.Instant;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.dataframe.transforms.util.TimeUtil;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.dataframe.DataFrameAnalysis;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.dataframe.DataFrameAnalyticsDest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.dataframe.DataFrameAnalyticsSource;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.unit.ByteSizeValue;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParserUtils;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.fetch.subphase.FetchSourceContext;

public class DataFrameAnalyticsConfig
implements ToXContentObject {
    private static final ParseField ID = new ParseField("id", new String[0]);
    private static final ParseField SOURCE = new ParseField("source", new String[0]);
    private static final ParseField DEST = new ParseField("dest", new String[0]);
    private static final ParseField ANALYSIS = new ParseField("analysis", new String[0]);
    private static final ParseField ANALYZED_FIELDS = new ParseField("analyzed_fields", new String[0]);
    private static final ParseField MODEL_MEMORY_LIMIT = new ParseField("model_memory_limit", new String[0]);
    private static final ParseField CREATE_TIME = new ParseField("create_time", new String[0]);
    private static final ParseField VERSION = new ParseField("version", new String[0]);
    private static ObjectParser<Builder, Void> PARSER = new ObjectParser("data_frame_analytics_config", true, () -> new Builder());
    private final String id;
    private final DataFrameAnalyticsSource source;
    private final DataFrameAnalyticsDest dest;
    private final DataFrameAnalysis analysis;
    private final FetchSourceContext analyzedFields;
    private final ByteSizeValue modelMemoryLimit;
    private final Instant createTime;
    private final Version version;

    public static DataFrameAnalyticsConfig fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null).build();
    }

    public static Builder builder(String id) {
        return new Builder().setId(id);
    }

    private static DataFrameAnalysis parseAnalysis(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser::getTokenLocation);
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, parser.nextToken(), parser::getTokenLocation);
        DataFrameAnalysis analysis = parser.namedObject(DataFrameAnalysis.class, parser.currentName(), true);
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.END_OBJECT, parser.nextToken(), parser::getTokenLocation);
        return analysis;
    }

    private DataFrameAnalyticsConfig(String id, DataFrameAnalyticsSource source, DataFrameAnalyticsDest dest, DataFrameAnalysis analysis, @Nullable FetchSourceContext analyzedFields, @Nullable ByteSizeValue modelMemoryLimit, @Nullable Instant createTime, @Nullable Version version) {
        this.id = Objects.requireNonNull(id);
        this.source = Objects.requireNonNull(source);
        this.dest = Objects.requireNonNull(dest);
        this.analysis = Objects.requireNonNull(analysis);
        this.analyzedFields = analyzedFields;
        this.modelMemoryLimit = modelMemoryLimit;
        this.createTime = createTime == null ? null : Instant.ofEpochMilli(createTime.toEpochMilli());
        this.version = version;
    }

    public String getId() {
        return this.id;
    }

    public DataFrameAnalyticsSource getSource() {
        return this.source;
    }

    public DataFrameAnalyticsDest getDest() {
        return this.dest;
    }

    public DataFrameAnalysis getAnalysis() {
        return this.analysis;
    }

    public FetchSourceContext getAnalyzedFields() {
        return this.analyzedFields;
    }

    public ByteSizeValue getModelMemoryLimit() {
        return this.modelMemoryLimit;
    }

    public Instant getCreateTime() {
        return this.createTime;
    }

    public Version getVersion() {
        return this.version;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(ID.getPreferredName(), this.id);
        builder.field(SOURCE.getPreferredName(), this.source);
        builder.field(DEST.getPreferredName(), this.dest);
        builder.startObject(ANALYSIS.getPreferredName());
        builder.field(this.analysis.getName(), this.analysis);
        builder.endObject();
        if (this.analyzedFields != null) {
            builder.field(ANALYZED_FIELDS.getPreferredName(), this.analyzedFields);
        }
        if (this.modelMemoryLimit != null) {
            builder.field(MODEL_MEMORY_LIMIT.getPreferredName(), this.modelMemoryLimit.getStringRep());
        }
        if (this.createTime != null) {
            builder.timeField(CREATE_TIME.getPreferredName(), CREATE_TIME.getPreferredName() + "_string", this.createTime.toEpochMilli());
        }
        if (this.version != null) {
            builder.field(VERSION.getPreferredName(), this.version);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataFrameAnalyticsConfig other = (DataFrameAnalyticsConfig)o;
        return Objects.equals(this.id, other.id) && Objects.equals(this.source, other.source) && Objects.equals(this.dest, other.dest) && Objects.equals(this.analysis, other.analysis) && Objects.equals(this.analyzedFields, other.analyzedFields) && Objects.equals(this.modelMemoryLimit, other.modelMemoryLimit) && Objects.equals(this.createTime, other.createTime) && Objects.equals(this.version, other.version);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.source, this.dest, this.analysis, this.analyzedFields, this.modelMemoryLimit, this.createTime, this.version);
    }

    public String toString() {
        return Strings.toString(this);
    }

    static {
        PARSER.declareString(Builder::setId, ID);
        PARSER.declareObject(Builder::setSource, (p, c) -> DataFrameAnalyticsSource.fromXContent(p), SOURCE);
        PARSER.declareObject(Builder::setDest, (p, c) -> DataFrameAnalyticsDest.fromXContent(p), DEST);
        PARSER.declareObject(Builder::setAnalysis, (p, c) -> DataFrameAnalyticsConfig.parseAnalysis(p), ANALYSIS);
        PARSER.declareField(Builder::setAnalyzedFields, (p, c) -> FetchSourceContext.fromXContent(p), ANALYZED_FIELDS, ObjectParser.ValueType.OBJECT_ARRAY_BOOLEAN_OR_STRING);
        PARSER.declareField(Builder::setModelMemoryLimit, (p, c) -> ByteSizeValue.parseBytesSizeValue(p.text(), MODEL_MEMORY_LIMIT.getPreferredName()), MODEL_MEMORY_LIMIT, ObjectParser.ValueType.VALUE);
        PARSER.declareField(Builder::setCreateTime, p -> TimeUtil.parseTimeFieldToInstant(p, CREATE_TIME.getPreferredName()), CREATE_TIME, ObjectParser.ValueType.VALUE);
        PARSER.declareField(Builder::setVersion, p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return Version.fromString(p.text());
            }
            throw new IllegalArgumentException("Unsupported token [" + (Object)((Object)p.currentToken()) + "]");
        }, VERSION, ObjectParser.ValueType.STRING);
    }

    public static class Builder {
        private String id;
        private DataFrameAnalyticsSource source;
        private DataFrameAnalyticsDest dest;
        private DataFrameAnalysis analysis;
        private FetchSourceContext analyzedFields;
        private ByteSizeValue modelMemoryLimit;
        private Instant createTime;
        private Version version;

        private Builder() {
        }

        public Builder setId(String id) {
            this.id = Objects.requireNonNull(id);
            return this;
        }

        public Builder setSource(DataFrameAnalyticsSource source) {
            this.source = Objects.requireNonNull(source);
            return this;
        }

        public Builder setDest(DataFrameAnalyticsDest dest) {
            this.dest = Objects.requireNonNull(dest);
            return this;
        }

        public Builder setAnalysis(DataFrameAnalysis analysis) {
            this.analysis = Objects.requireNonNull(analysis);
            return this;
        }

        public Builder setAnalyzedFields(FetchSourceContext fields) {
            this.analyzedFields = fields;
            return this;
        }

        public Builder setModelMemoryLimit(ByteSizeValue modelMemoryLimit) {
            this.modelMemoryLimit = modelMemoryLimit;
            return this;
        }

        public Builder setCreateTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public Builder setVersion(Version version) {
            this.version = version;
            return this;
        }

        public DataFrameAnalyticsConfig build() {
            return new DataFrameAnalyticsConfig(this.id, this.source, this.dest, this.analysis, this.analyzedFields, this.modelMemoryLimit, this.createTime, this.version);
        }
    }
}

