/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;

public abstract class AbstractResultResponse<T extends ToXContent>
extends ActionResponse
implements ToXContentObject {
    public static final ParseField COUNT = new ParseField("count", new String[0]);
    private final ParseField resultsField;
    protected final List<T> results;
    protected final long count;

    AbstractResultResponse(ParseField resultsField, List<T> results, long count) {
        this.resultsField = Objects.requireNonNull(resultsField, "[results_field] must not be null");
        this.results = Collections.unmodifiableList(results);
        this.count = count;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(COUNT.getPreferredName(), this.count);
        builder.field(this.resultsField.getPreferredName(), this.results);
        builder.endObject();
        return builder;
    }

    public long count() {
        return this.count;
    }
}

