/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.dataframe.transforms.pivot;

import java.io.IOException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.dataframe.transforms.pivot.SingleGroupSource;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentFragment;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;

public class DateHistogramGroupSource
extends SingleGroupSource
implements ToXContentObject {
    private static final ParseField TIME_ZONE = new ParseField("time_zone", new String[0]);
    private static final Set<String> DATE_FIELD_UNITS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("year", "1y", "quarter", "1q", "month", "1M", "week", "1w", "day", "1d", "hour", "1h", "minute", "1m", "second", "1s")));
    private static final ConstructingObjectParser<DateHistogramGroupSource, Void> PARSER = new ConstructingObjectParser("date_histogram_group_source", true, args -> {
        String field = (String)args[0];
        String fixedInterval = (String)args[1];
        String calendarInterval = (String)args[2];
        Interval interval = null;
        if (fixedInterval != null && calendarInterval != null) {
            throw new IllegalArgumentException("You must specify either fixed_interval or calendar_interval, found both");
        }
        if (fixedInterval != null) {
            interval = new FixedInterval(new DateHistogramInterval(fixedInterval));
        } else if (calendarInterval != null) {
            interval = new CalendarInterval(new DateHistogramInterval(calendarInterval));
        } else {
            throw new IllegalArgumentException("You must specify either fixed_interval or calendar_interval, found none");
        }
        ZoneId zoneId = (ZoneId)args[3];
        return new DateHistogramGroupSource(field, interval, zoneId);
    });
    private final Interval interval;
    private final ZoneId timeZone;

    public static DateHistogramGroupSource fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    DateHistogramGroupSource(String field, Interval interval, ZoneId timeZone) {
        super(field);
        this.interval = interval;
        this.timeZone = timeZone;
    }

    @Override
    public SingleGroupSource.Type getType() {
        return SingleGroupSource.Type.DATE_HISTOGRAM;
    }

    public Interval getInterval() {
        return this.interval;
    }

    public ZoneId getTimeZone() {
        return this.timeZone;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.field != null) {
            builder.field(FIELD.getPreferredName(), this.field);
        }
        this.interval.toXContent(builder, params);
        if (this.timeZone != null) {
            builder.field(TIME_ZONE.getPreferredName(), this.timeZone.toString());
        }
        builder.endObject();
        return builder;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DateHistogramGroupSource that = (DateHistogramGroupSource)other;
        return Objects.equals(this.field, that.field) && Objects.equals(this.interval, that.interval) && Objects.equals(this.timeZone, that.timeZone);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.field, this.interval, this.timeZone);
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), FIELD);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("fixed_interval", new String[0]));
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("calendar_interval", new String[0]));
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> {
            if (p.currentToken() == XContentParser.Token.VALUE_STRING) {
                return ZoneId.of(p.text());
            }
            return ZoneOffset.ofHours(p.intValue());
        }, TIME_ZONE, ObjectParser.ValueType.LONG);
    }

    public static class Builder {
        private String field;
        private Interval interval;
        private ZoneId timeZone;

        public Builder setField(String field) {
            this.field = field;
            return this;
        }

        public Builder setInterval(Interval interval) {
            this.interval = interval;
            return this;
        }

        public Builder setTimeZone(ZoneId timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public DateHistogramGroupSource build() {
            return new DateHistogramGroupSource(this.field, this.interval, this.timeZone);
        }
    }

    public static class CalendarInterval
    implements Interval {
        private static final String NAME = "calendar_interval";
        private final DateHistogramInterval interval;

        public CalendarInterval(DateHistogramInterval interval) {
            this.interval = interval;
            if (!DATE_FIELD_UNITS.contains(interval.toString())) {
                throw new IllegalArgumentException("The supplied interval [" + interval + "] could not be parsed as a calendar interval.");
            }
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public DateHistogramInterval getInterval() {
            return this.interval;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(NAME);
            this.interval.toXContent(builder, params);
            return builder;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            CalendarInterval that = (CalendarInterval)other;
            return Objects.equals(this.interval, that.interval);
        }

        public int hashCode() {
            return Objects.hash(this.interval);
        }
    }

    public static class FixedInterval
    implements Interval {
        private static final String NAME = "fixed_interval";
        private final DateHistogramInterval interval;

        public FixedInterval(DateHistogramInterval interval) {
            this.interval = interval;
        }

        @Override
        public String getName() {
            return NAME;
        }

        @Override
        public DateHistogramInterval getInterval() {
            return this.interval;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(NAME);
            this.interval.toXContent(builder, params);
            return builder;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            FixedInterval that = (FixedInterval)other;
            return Objects.equals(this.interval, that.interval);
        }

        public int hashCode() {
            return Objects.hash(this.interval);
        }
    }

    public static interface Interval
    extends ToXContentFragment {
        public String getName();

        public DateHistogramInterval getInterval();
    }
}

