/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.dataframe.transforms;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.dataframe.transforms.DataFrameIndexerTransformStats;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.dataframe.transforms.DataFrameTransformCheckpointingInfo;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.dataframe.transforms.DataFrameTransformState;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;

public class DataFrameTransformStateAndStats {
    public static final ParseField ID = new ParseField("id", new String[0]);
    public static final ParseField STATE_FIELD = new ParseField("state", new String[0]);
    public static final ParseField STATS_FIELD = new ParseField("stats", new String[0]);
    public static final ParseField CHECKPOINTING_INFO_FIELD = new ParseField("checkpointing", new String[0]);
    public static final ConstructingObjectParser<DataFrameTransformStateAndStats, Void> PARSER = new ConstructingObjectParser("data_frame_transform_state_and_stats", true, a -> new DataFrameTransformStateAndStats((String)a[0], (DataFrameTransformState)a[1], (DataFrameIndexerTransformStats)a[2], (DataFrameTransformCheckpointingInfo)a[3]));
    private final String id;
    private final DataFrameTransformState transformState;
    private final DataFrameIndexerTransformStats transformStats;
    private final DataFrameTransformCheckpointingInfo checkpointingInfo;

    public static DataFrameTransformStateAndStats fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    public DataFrameTransformStateAndStats(String id, DataFrameTransformState state, DataFrameIndexerTransformStats stats, DataFrameTransformCheckpointingInfo checkpointingInfo) {
        this.id = id;
        this.transformState = state;
        this.transformStats = stats;
        this.checkpointingInfo = checkpointingInfo;
    }

    public String getId() {
        return this.id;
    }

    public DataFrameIndexerTransformStats getTransformStats() {
        return this.transformStats;
    }

    public DataFrameTransformState getTransformState() {
        return this.transformState;
    }

    public DataFrameTransformCheckpointingInfo getCheckpointingInfo() {
        return this.checkpointingInfo;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.transformState, this.transformStats, this.checkpointingInfo);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DataFrameTransformStateAndStats that = (DataFrameTransformStateAndStats)other;
        return Objects.equals(this.id, that.id) && Objects.equals(this.transformState, that.transformState) && Objects.equals(this.transformStats, that.transformStats) && Objects.equals(this.checkpointingInfo, that.checkpointingInfo);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), ID);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), DataFrameTransformState.PARSER::apply, STATE_FIELD);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> DataFrameIndexerTransformStats.fromXContent(p), STATS_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> DataFrameTransformCheckpointingInfo.fromXContent(p), CHECKPOINTING_INFO_FIELD);
    }
}

