/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.dataframe.transforms;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.core.IndexerState;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.dataframe.transforms.DataFrameIndexerPosition;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.dataframe.transforms.DataFrameTransformProgress;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.dataframe.transforms.DataFrameTransformTaskState;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.dataframe.transforms.NodeAttributes;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;

public class DataFrameTransformState {
    private static final ParseField INDEXER_STATE = new ParseField("indexer_state", new String[0]);
    private static final ParseField TASK_STATE = new ParseField("task_state", new String[0]);
    private static final ParseField CURRENT_POSITION = new ParseField("current_position", new String[0]);
    private static final ParseField POSITION = new ParseField("position", new String[0]);
    private static final ParseField CHECKPOINT = new ParseField("checkpoint", new String[0]);
    private static final ParseField REASON = new ParseField("reason", new String[0]);
    private static final ParseField PROGRESS = new ParseField("progress", new String[0]);
    private static final ParseField NODE = new ParseField("node", new String[0]);
    public static final ConstructingObjectParser<DataFrameTransformState, Void> PARSER = new ConstructingObjectParser("data_frame_transform_state", true, args -> {
        DataFrameTransformTaskState taskState = (DataFrameTransformTaskState)((Object)((Object)args[0]));
        IndexerState indexerState = (IndexerState)((Object)((Object)args[1]));
        Map bwcCurrentPosition = (Map)args[2];
        DataFrameIndexerPosition dataFrameIndexerPosition = (DataFrameIndexerPosition)args[3];
        if (bwcCurrentPosition != null && dataFrameIndexerPosition == null) {
            dataFrameIndexerPosition = new DataFrameIndexerPosition(bwcCurrentPosition, null);
        }
        long checkpoint = (Long)args[4];
        String reason = (String)args[5];
        DataFrameTransformProgress progress = (DataFrameTransformProgress)args[6];
        NodeAttributes node = (NodeAttributes)args[7];
        return new DataFrameTransformState(taskState, indexerState, dataFrameIndexerPosition, checkpoint, reason, progress, node);
    });
    private final DataFrameTransformTaskState taskState;
    private final IndexerState indexerState;
    private final long checkpoint;
    private final DataFrameIndexerPosition position;
    private final String reason;
    private final DataFrameTransformProgress progress;
    private final NodeAttributes node;

    public static DataFrameTransformState fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    public DataFrameTransformState(DataFrameTransformTaskState taskState, IndexerState indexerState, @Nullable DataFrameIndexerPosition position, long checkpoint, @Nullable String reason, @Nullable DataFrameTransformProgress progress, @Nullable NodeAttributes node) {
        this.taskState = taskState;
        this.indexerState = indexerState;
        this.position = position;
        this.checkpoint = checkpoint;
        this.reason = reason;
        this.progress = progress;
        this.node = node;
    }

    public IndexerState getIndexerState() {
        return this.indexerState;
    }

    public DataFrameTransformTaskState getTaskState() {
        return this.taskState;
    }

    @Nullable
    public DataFrameIndexerPosition getPosition() {
        return this.position;
    }

    public long getCheckpoint() {
        return this.checkpoint;
    }

    @Nullable
    public String getReason() {
        return this.reason;
    }

    @Nullable
    public DataFrameTransformProgress getProgress() {
        return this.progress;
    }

    @Nullable
    public NodeAttributes getNode() {
        return this.node;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DataFrameTransformState that = (DataFrameTransformState)other;
        return Objects.equals((Object)this.taskState, (Object)that.taskState) && Objects.equals((Object)this.indexerState, (Object)that.indexerState) && Objects.equals(this.position, that.position) && Objects.equals(this.progress, that.progress) && this.checkpoint == that.checkpoint && Objects.equals(this.node, that.node) && Objects.equals(this.reason, that.reason);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.taskState, this.indexerState, this.position, this.checkpoint, this.reason, this.progress, this.node});
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> DataFrameTransformTaskState.fromString(p.text()), TASK_STATE, ObjectParser.ValueType.STRING);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> IndexerState.fromString(p.text()), INDEXER_STATE, ObjectParser.ValueType.STRING);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.mapOrdered(), CURRENT_POSITION, ObjectParser.ValueType.OBJECT);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), DataFrameIndexerPosition::fromXContent, POSITION, ObjectParser.ValueType.OBJECT);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), CHECKPOINT);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), REASON);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), DataFrameTransformProgress::fromXContent, PROGRESS, ObjectParser.ValueType.OBJECT);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), NodeAttributes.PARSER::apply, NODE, ObjectParser.ValueType.OBJECT);
    }
}

