/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.dataframe;

import java.util.Objects;
import java.util.Optional;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.Validatable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ValidationException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.unit.TimeValue;

public class StopDataFrameTransformRequest
implements Validatable {
    private final String id;
    private Boolean waitForCompletion;
    private TimeValue timeout;
    private Boolean allowNoMatch;

    public StopDataFrameTransformRequest(String id) {
        this.id = id;
        this.waitForCompletion = null;
        this.timeout = null;
    }

    public StopDataFrameTransformRequest(String id, Boolean waitForCompletion, TimeValue timeout) {
        this.id = id;
        this.waitForCompletion = waitForCompletion;
        this.timeout = timeout;
    }

    public String getId() {
        return this.id;
    }

    public void setWaitForCompletion(Boolean waitForCompletion) {
        this.waitForCompletion = waitForCompletion;
    }

    public Boolean getWaitForCompletion() {
        return this.waitForCompletion;
    }

    public void setTimeout(TimeValue timeout) {
        this.timeout = timeout;
    }

    public TimeValue getTimeout() {
        return this.timeout;
    }

    public Boolean getAllowNoMatch() {
        return this.allowNoMatch;
    }

    public void setAllowNoMatch(Boolean allowNoMatch) {
        this.allowNoMatch = allowNoMatch;
    }

    @Override
    public Optional<ValidationException> validate() {
        if (this.id == null) {
            ValidationException validationException = new ValidationException();
            validationException.addValidationError("data frame transform id must not be null");
            return Optional.of(validationException);
        }
        return Optional.empty();
    }

    public int hashCode() {
        return Objects.hash(this.id, this.waitForCompletion, this.timeout, this.allowNoMatch);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StopDataFrameTransformRequest other = (StopDataFrameTransformRequest)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.waitForCompletion, other.waitForCompletion) && Objects.equals(this.timeout, other.timeout) && Objects.equals(this.allowNoMatch, other.allowNoMatch);
    }
}

