/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.dataframe;

import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.Validatable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ValidationException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.dataframe.transforms.DataFrameTransformConfig;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;

public class PreviewDataFrameTransformRequest
implements ToXContentObject,
Validatable {
    private final DataFrameTransformConfig config;

    public PreviewDataFrameTransformRequest(DataFrameTransformConfig config) {
        this.config = config;
    }

    public DataFrameTransformConfig getConfig() {
        return this.config;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return this.config.toXContent(builder, params);
    }

    @Override
    public Optional<ValidationException> validate() {
        ValidationException validationException = new ValidationException();
        if (this.config == null) {
            validationException.addValidationError("preview requires a non-null data frame config");
            return Optional.of(validationException);
        }
        if (this.config.getSource() == null) {
            validationException.addValidationError("data frame transform source cannot be null");
        }
        if (validationException.validationErrors().isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(validationException);
    }

    public int hashCode() {
        return Objects.hash(this.config);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PreviewDataFrameTransformRequest other = (PreviewDataFrameTransformRequest)obj;
        return Objects.equals(this.config, other.config);
    }
}

