/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.dataframe;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ElasticsearchException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.TaskOperationFailure;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.dataframe.AcknowledgedTasksResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.dataframe.transforms.DataFrameTransformStateAndStats;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;

public class GetDataFrameTransformStatsResponse {
    public static final ParseField TRANSFORMS = new ParseField("transforms", new String[0]);
    public static final ParseField COUNT = new ParseField("count", new String[0]);
    static final ConstructingObjectParser<GetDataFrameTransformStatsResponse, Void> PARSER = new ConstructingObjectParser("get_data_frame_transform_stats_response", true, args -> new GetDataFrameTransformStatsResponse((List)args[0], (List)args[1], (List)args[2]));
    private final List<DataFrameTransformStateAndStats> transformsStateAndStats;
    private final List<TaskOperationFailure> taskFailures;
    private final List<ElasticsearchException> nodeFailures;

    public static GetDataFrameTransformStatsResponse fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public GetDataFrameTransformStatsResponse(List<DataFrameTransformStateAndStats> transformsStateAndStats, @Nullable List<TaskOperationFailure> taskFailures, @Nullable List<? extends ElasticsearchException> nodeFailures) {
        this.transformsStateAndStats = transformsStateAndStats;
        this.taskFailures = taskFailures == null ? Collections.emptyList() : Collections.unmodifiableList(taskFailures);
        this.nodeFailures = nodeFailures == null ? Collections.emptyList() : Collections.unmodifiableList(nodeFailures);
    }

    public List<DataFrameTransformStateAndStats> getTransformsStateAndStats() {
        return this.transformsStateAndStats;
    }

    public List<ElasticsearchException> getNodeFailures() {
        return this.nodeFailures;
    }

    public List<TaskOperationFailure> getTaskFailures() {
        return this.taskFailures;
    }

    public int hashCode() {
        return Objects.hash(this.transformsStateAndStats, this.nodeFailures, this.taskFailures);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        GetDataFrameTransformStatsResponse that = (GetDataFrameTransformStatsResponse)other;
        return Objects.equals(this.transformsStateAndStats, that.transformsStateAndStats) && Objects.equals(this.nodeFailures, that.nodeFailures) && Objects.equals(this.taskFailures, that.taskFailures);
    }

    static {
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), DataFrameTransformStateAndStats.PARSER::apply, TRANSFORMS);
        PARSER.declareInt((a, b) -> {}, COUNT);
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> TaskOperationFailure.fromXContent(p), AcknowledgedTasksResponse.TASK_FAILURES);
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ElasticsearchException.fromXContent(p), AcknowledgedTasksResponse.NODE_FAILURES);
    }
}

