/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.dataframe;

import java.util.Objects;
import java.util.Optional;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.Validatable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ValidationException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.core.PageParams;

public class GetDataFrameTransformStatsRequest
implements Validatable {
    private final String id;
    private PageParams pageParams;
    private Boolean allowNoMatch;

    public GetDataFrameTransformStatsRequest(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public PageParams getPageParams() {
        return this.pageParams;
    }

    public void setPageParams(PageParams pageParams) {
        this.pageParams = pageParams;
    }

    public Boolean getAllowNoMatch() {
        return this.allowNoMatch;
    }

    public void setAllowNoMatch(Boolean allowNoMatch) {
        this.allowNoMatch = allowNoMatch;
    }

    @Override
    public Optional<ValidationException> validate() {
        if (this.id == null) {
            ValidationException validationException = new ValidationException();
            validationException.addValidationError("data frame transform id must not be null");
            return Optional.of(validationException);
        }
        return Optional.empty();
    }

    public int hashCode() {
        return Objects.hash(this.id, this.pageParams, this.allowNoMatch);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GetDataFrameTransformStatsRequest other = (GetDataFrameTransformStatsRequest)obj;
        return Objects.equals(this.id, other.id) && Objects.equals(this.pageParams, other.pageParams) && Objects.equals(this.allowNoMatch, other.allowNoMatch);
    }
}

