/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.dataframe;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.Validatable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ValidationException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.core.PageParams;

public class GetDataFrameTransformRequest
implements Validatable {
    public static final String ALLOW_NO_MATCH = "allow_no_match";
    private final List<String> ids;
    private PageParams pageParams;
    private Boolean allowNoMatch;

    public static GetDataFrameTransformRequest getAllDataFrameTransformsRequest() {
        return new GetDataFrameTransformRequest("_all");
    }

    public GetDataFrameTransformRequest(String ... ids) {
        this.ids = Arrays.asList(ids);
    }

    public List<String> getId() {
        return this.ids;
    }

    public PageParams getPageParams() {
        return this.pageParams;
    }

    public void setPageParams(PageParams pageParams) {
        this.pageParams = pageParams;
    }

    public Boolean getAllowNoMatch() {
        return this.allowNoMatch;
    }

    public void setAllowNoMatch(Boolean allowNoMatch) {
        this.allowNoMatch = allowNoMatch;
    }

    @Override
    public Optional<ValidationException> validate() {
        if (this.ids == null || this.ids.isEmpty()) {
            ValidationException validationException = new ValidationException();
            validationException.addValidationError("data frame transform id must not be null");
            return Optional.of(validationException);
        }
        return Optional.empty();
    }

    public int hashCode() {
        return Objects.hash(this.ids, this.pageParams, this.allowNoMatch);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GetDataFrameTransformRequest other = (GetDataFrameTransformRequest)obj;
        return Objects.equals(this.ids, other.ids) && Objects.equals(this.pageParams, other.pageParams) && Objects.equals(this.allowNoMatch, other.allowNoMatch);
    }
}

