/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.dataframe;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ElasticsearchException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.TaskOperationFailure;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.TriFunction;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;

public class AcknowledgedTasksResponse {
    public static final ParseField TASK_FAILURES = new ParseField("task_failures", new String[0]);
    public static final ParseField NODE_FAILURES = new ParseField("node_failures", new String[0]);
    private boolean acknowledged;
    private List<TaskOperationFailure> taskFailures;
    private List<ElasticsearchException> nodeFailures;

    protected static <T extends AcknowledgedTasksResponse> ConstructingObjectParser<T, Void> generateParser(String name, TriFunction<Boolean, List<TaskOperationFailure>, List<? extends ElasticsearchException>, T> ctor, String ackFieldName) {
        ConstructingObjectParser<AcknowledgedTasksResponse, Void> parser = new ConstructingObjectParser<AcknowledgedTasksResponse, Void>(name, true, args -> (AcknowledgedTasksResponse)ctor.apply((Boolean)args[0], (List)args[1], (List)args[2]));
        parser.declareBoolean(ConstructingObjectParser.constructorArg(), new ParseField(ackFieldName, new String[0]));
        parser.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> TaskOperationFailure.fromXContent(p), TASK_FAILURES);
        parser.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ElasticsearchException.fromXContent(p), NODE_FAILURES);
        return parser;
    }

    public AcknowledgedTasksResponse(boolean acknowledged, @Nullable List<TaskOperationFailure> taskFailures, @Nullable List<? extends ElasticsearchException> nodeFailures) {
        this.acknowledged = acknowledged;
        this.taskFailures = taskFailures == null ? Collections.emptyList() : Collections.unmodifiableList(taskFailures);
        this.nodeFailures = nodeFailures == null ? Collections.emptyList() : Collections.unmodifiableList(nodeFailures);
    }

    public boolean isAcknowledged() {
        return this.acknowledged;
    }

    public List<TaskOperationFailure> getTaskFailures() {
        return this.taskFailures;
    }

    public List<ElasticsearchException> getNodeFailures() {
        return this.nodeFailures;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AcknowledgedTasksResponse other = (AcknowledgedTasksResponse)obj;
        return this.acknowledged == other.acknowledged && this.taskFailures.equals(other.taskFailures) && this.nodeFailures.equals(other.nodeFailures);
    }

    public int hashCode() {
        return Objects.hash(this.acknowledged, this.taskFailures, this.nodeFailures);
    }
}

