/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client;

import java.io.IOException;
import java.util.Collections;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.RequestOptions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.RestHighLevelClient;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.XPackRequestConverters;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.xpack.XPackInfoRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.xpack.XPackInfoResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.xpack.XPackUsageRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.xpack.XPackUsageResponse;

public final class XPackClient {
    private final RestHighLevelClient restHighLevelClient;

    XPackClient(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    public XPackInfoResponse info(XPackInfoRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, XPackRequestConverters::info, options, XPackInfoResponse::fromXContent, Collections.emptySet());
    }

    public void infoAsync(XPackInfoRequest request, RequestOptions options, ActionListener<XPackInfoResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, XPackRequestConverters::info, options, XPackInfoResponse::fromXContent, listener, Collections.emptySet());
    }

    public XPackUsageResponse usage(XPackUsageRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, XPackRequestConverters::usage, options, XPackUsageResponse::fromXContent, Collections.emptySet());
    }

    public void usageAsync(XPackUsageRequest request, RequestOptions options, ActionListener<XPackUsageResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, XPackRequestConverters::usage, options, XPackUsageResponse::fromXContent, listener, Collections.emptySet());
    }
}

