/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.cluster.repositories.delete.DeleteRepositoryRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.cluster.repositories.get.GetRepositoriesRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.cluster.repositories.put.PutRepositoryRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.cluster.repositories.verify.VerifyRepositoryRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.cluster.snapshots.create.CreateSnapshotRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.cluster.snapshots.delete.DeleteSnapshotRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotsStatusRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.Request;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.RequestConverters;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;

final class SnapshotRequestConverters {
    private SnapshotRequestConverters() {
    }

    static Request getRepositories(GetRepositoriesRequest getRepositoriesRequest) {
        String[] repositories = getRepositoriesRequest.repositories() == null ? Strings.EMPTY_ARRAY : getRepositoriesRequest.repositories();
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_snapshot").addCommaSeparatedPathParts(repositories).build();
        Request request = new Request("GET", endpoint);
        RequestConverters.Params parameters = new RequestConverters.Params();
        parameters.withMasterTimeout(getRepositoriesRequest.masterNodeTimeout());
        parameters.withLocal(getRepositoriesRequest.local());
        request.addParameters(parameters.asMap());
        return request;
    }

    static Request createRepository(PutRepositoryRequest putRepositoryRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPart("_snapshot").addPathPart(putRepositoryRequest.name()).build();
        Request request = new Request("PUT", endpoint);
        RequestConverters.Params parameters = new RequestConverters.Params();
        parameters.withMasterTimeout(putRepositoryRequest.masterNodeTimeout());
        parameters.withTimeout(putRepositoryRequest.timeout());
        if (!putRepositoryRequest.verify()) {
            parameters.putParam("verify", "false");
        }
        request.addParameters(parameters.asMap());
        request.setEntity(RequestConverters.createEntity(putRepositoryRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request deleteRepository(DeleteRepositoryRequest deleteRepositoryRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_snapshot").addPathPart(deleteRepositoryRequest.name()).build();
        Request request = new Request("DELETE", endpoint);
        RequestConverters.Params parameters = new RequestConverters.Params();
        parameters.withMasterTimeout(deleteRepositoryRequest.masterNodeTimeout());
        parameters.withTimeout(deleteRepositoryRequest.timeout());
        request.addParameters(parameters.asMap());
        return request;
    }

    static Request verifyRepository(VerifyRepositoryRequest verifyRepositoryRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_snapshot").addPathPart(verifyRepositoryRequest.name()).addPathPartAsIs("_verify").build();
        Request request = new Request("POST", endpoint);
        RequestConverters.Params parameters = new RequestConverters.Params();
        parameters.withMasterTimeout(verifyRepositoryRequest.masterNodeTimeout());
        parameters.withTimeout(verifyRepositoryRequest.timeout());
        request.addParameters(parameters.asMap());
        return request;
    }

    static Request createSnapshot(CreateSnapshotRequest createSnapshotRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPart("_snapshot").addPathPart(createSnapshotRequest.repository()).addPathPart(createSnapshotRequest.snapshot()).build();
        Request request = new Request("PUT", endpoint);
        RequestConverters.Params params = new RequestConverters.Params();
        params.withMasterTimeout(createSnapshotRequest.masterNodeTimeout());
        params.withWaitForCompletion(createSnapshotRequest.waitForCompletion());
        request.addParameters(params.asMap());
        request.setEntity(RequestConverters.createEntity(createSnapshotRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request getSnapshots(GetSnapshotsRequest getSnapshotsRequest) {
        RequestConverters.EndpointBuilder endpointBuilder = new RequestConverters.EndpointBuilder().addPathPartAsIs("_snapshot").addPathPart(getSnapshotsRequest.repository());
        String endpoint = getSnapshotsRequest.snapshots().length == 0 ? endpointBuilder.addPathPart("_all").build() : endpointBuilder.addCommaSeparatedPathParts(getSnapshotsRequest.snapshots()).build();
        Request request = new Request("GET", endpoint);
        RequestConverters.Params parameters = new RequestConverters.Params();
        parameters.withMasterTimeout(getSnapshotsRequest.masterNodeTimeout());
        parameters.putParam("ignore_unavailable", Boolean.toString(getSnapshotsRequest.ignoreUnavailable()));
        parameters.putParam("verbose", Boolean.toString(getSnapshotsRequest.verbose()));
        request.addParameters(parameters.asMap());
        return request;
    }

    static Request snapshotsStatus(SnapshotsStatusRequest snapshotsStatusRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_snapshot").addPathPart(snapshotsStatusRequest.repository()).addCommaSeparatedPathParts(snapshotsStatusRequest.snapshots()).addPathPartAsIs("_status").build();
        Request request = new Request("GET", endpoint);
        RequestConverters.Params parameters = new RequestConverters.Params();
        parameters.withMasterTimeout(snapshotsStatusRequest.masterNodeTimeout());
        parameters.withIgnoreUnavailable(snapshotsStatusRequest.ignoreUnavailable());
        request.addParameters(parameters.asMap());
        return request;
    }

    static Request restoreSnapshot(RestoreSnapshotRequest restoreSnapshotRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_snapshot").addPathPart(restoreSnapshotRequest.repository()).addPathPart(restoreSnapshotRequest.snapshot()).addPathPartAsIs("_restore").build();
        Request request = new Request("POST", endpoint);
        RequestConverters.Params parameters = new RequestConverters.Params();
        parameters.withMasterTimeout(restoreSnapshotRequest.masterNodeTimeout());
        parameters.withWaitForCompletion(restoreSnapshotRequest.waitForCompletion());
        request.addParameters(parameters.asMap());
        request.setEntity(RequestConverters.createEntity(restoreSnapshotRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request deleteSnapshot(DeleteSnapshotRequest deleteSnapshotRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_snapshot").addPathPart(deleteSnapshotRequest.repository()).addPathPart(deleteSnapshotRequest.snapshot()).build();
        Request request = new Request("DELETE", endpoint);
        RequestConverters.Params parameters = new RequestConverters.Params();
        parameters.withMasterTimeout(deleteSnapshotRequest.masterNodeTimeout());
        request.addParameters(parameters.asMap());
        return request;
    }
}

