/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.apache.flink.elasticsearch7.shaded.org.apache.http.HttpEntity;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.LicenseRequestConverters;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.RequestOptions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.Response;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.RestHighLevelClient;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.Validatable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.license.DeleteLicenseRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.license.GetBasicStatusResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.license.GetLicenseRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.license.GetLicenseResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.license.GetTrialStatusResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.license.PutLicenseRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.license.PutLicenseResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.license.StartBasicRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.license.StartBasicResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.license.StartTrialRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.license.StartTrialResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.Streams;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.DeprecationHandler;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentFactory;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentType;

public final class LicenseClient {
    private final RestHighLevelClient restHighLevelClient;

    LicenseClient(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    public PutLicenseResponse putLicense(PutLicenseRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, LicenseRequestConverters::putLicense, options, PutLicenseResponse::fromXContent, Collections.emptySet());
    }

    public void putLicenseAsync(PutLicenseRequest request, RequestOptions options, ActionListener<PutLicenseResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, LicenseRequestConverters::putLicense, options, PutLicenseResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetLicenseResponse getLicense(GetLicenseRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequest(request, LicenseRequestConverters::getLicense, options, response -> new GetLicenseResponse(LicenseClient.convertResponseToJson(response)), Collections.emptySet());
    }

    public void getLicenseAsync(GetLicenseRequest request, RequestOptions options, ActionListener<GetLicenseResponse> listener) {
        this.restHighLevelClient.performRequestAsync(request, LicenseRequestConverters::getLicense, options, response -> new GetLicenseResponse(LicenseClient.convertResponseToJson(response)), listener, Collections.emptySet());
    }

    public AcknowledgedResponse deleteLicense(DeleteLicenseRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, LicenseRequestConverters::deleteLicense, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public void deleteLicenseAsync(DeleteLicenseRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, LicenseRequestConverters::deleteLicense, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public StartTrialResponse startTrial(StartTrialRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, LicenseRequestConverters::startTrial, options, StartTrialResponse::fromXContent, Collections.singleton(403));
    }

    public void startTrialAsync(StartTrialRequest request, RequestOptions options, ActionListener<StartTrialResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, LicenseRequestConverters::startTrial, options, StartTrialResponse::fromXContent, listener, Collections.singleton(403));
    }

    public StartBasicResponse startBasic(StartBasicRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, LicenseRequestConverters::startBasic, options, StartBasicResponse::fromXContent, Collections.emptySet());
    }

    public void startBasicAsync(StartBasicRequest request, RequestOptions options, ActionListener<StartBasicResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, LicenseRequestConverters::startBasic, options, StartBasicResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetTrialStatusResponse getTrialStatus(RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(Validatable.EMPTY, request -> LicenseRequestConverters.getLicenseTrialStatus(), options, GetTrialStatusResponse::fromXContent, Collections.emptySet());
    }

    public GetBasicStatusResponse getBasicStatus(RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(Validatable.EMPTY, request -> LicenseRequestConverters.getLicenseBasicStatus(), options, GetBasicStatusResponse::fromXContent, Collections.emptySet());
    }

    static String convertResponseToJson(Response response) throws IOException {
        HttpEntity entity = response.getEntity();
        if (entity == null) {
            throw new IllegalStateException("Response body expected but not returned");
        }
        if (entity.getContentType() == null) {
            throw new IllegalStateException("Elasticsearch didn't return the [Content-Type] header, unable to parse response body");
        }
        XContentType xContentType = XContentType.fromMediaTypeOrFormat(entity.getContentType().getValue());
        if (xContentType == null) {
            throw new IllegalStateException("Unsupported Content-Type: " + entity.getContentType().getValue());
        }
        if (xContentType == XContentType.JSON) {
            return Streams.copyToString(new InputStreamReader(response.getEntity().getContent(), StandardCharsets.UTF_8));
        }
        try (InputStream stream = response.getEntity().getContent();){
            String string;
            block16: {
                XContentParser parser = XContentFactory.xContent(xContentType).createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, stream);
                try {
                    parser.nextToken();
                    XContentBuilder builder = XContentFactory.jsonBuilder();
                    builder.copyCurrentStructure(parser);
                    string = Strings.toString(builder);
                    if (parser == null) break block16;
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                parser.close();
            }
            return string;
        }
    }
}

