/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.Request;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.RequestConverters;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.core.PageParams;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.dataframe.DeleteDataFrameTransformRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.dataframe.GetDataFrameTransformRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.dataframe.GetDataFrameTransformStatsRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.dataframe.PreviewDataFrameTransformRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.dataframe.PutDataFrameTransformRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.dataframe.StartDataFrameTransformRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.dataframe.StopDataFrameTransformRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;

final class DataFrameRequestConverters {
    private DataFrameRequestConverters() {
    }

    static Request putDataFrameTransform(PutDataFrameTransformRequest putRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_data_frame", "transforms").addPathPart(putRequest.getConfig().getId()).build();
        Request request = new Request("PUT", endpoint);
        request.setEntity(RequestConverters.createEntity(putRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request getDataFrameTransform(GetDataFrameTransformRequest getRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_data_frame", "transforms").addPathPart(Strings.collectionToCommaDelimitedString(getRequest.getId())).build();
        Request request = new Request("GET", endpoint);
        if (getRequest.getPageParams() != null && getRequest.getPageParams().getFrom() != null) {
            request.addParameter(PageParams.FROM.getPreferredName(), getRequest.getPageParams().getFrom().toString());
        }
        if (getRequest.getPageParams() != null && getRequest.getPageParams().getSize() != null) {
            request.addParameter(PageParams.SIZE.getPreferredName(), getRequest.getPageParams().getSize().toString());
        }
        if (getRequest.getAllowNoMatch() != null) {
            request.addParameter("allow_no_match", getRequest.getAllowNoMatch().toString());
        }
        return request;
    }

    static Request deleteDataFrameTransform(DeleteDataFrameTransformRequest request) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_data_frame", "transforms").addPathPart(request.getId()).build();
        return new Request("DELETE", endpoint);
    }

    static Request startDataFrameTransform(StartDataFrameTransformRequest startRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_data_frame", "transforms").addPathPart(startRequest.getId()).addPathPartAsIs("_start").build();
        Request request = new Request("POST", endpoint);
        RequestConverters.Params params = new RequestConverters.Params();
        if (startRequest.getTimeout() != null) {
            params.withTimeout(startRequest.getTimeout());
        }
        request.addParameters(params.asMap());
        return request;
    }

    static Request stopDataFrameTransform(StopDataFrameTransformRequest stopRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_data_frame", "transforms").addPathPart(stopRequest.getId()).addPathPartAsIs("_stop").build();
        Request request = new Request("POST", endpoint);
        RequestConverters.Params params = new RequestConverters.Params();
        if (stopRequest.getWaitForCompletion() != null) {
            params.withWaitForCompletion(stopRequest.getWaitForCompletion());
        }
        if (stopRequest.getTimeout() != null) {
            params.withTimeout(stopRequest.getTimeout());
        }
        if (stopRequest.getAllowNoMatch() != null) {
            request.addParameter("allow_no_match", stopRequest.getAllowNoMatch().toString());
        }
        request.addParameters(params.asMap());
        return request;
    }

    static Request previewDataFrameTransform(PreviewDataFrameTransformRequest previewRequest) throws IOException {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_data_frame", "transforms", "_preview").build();
        Request request = new Request("POST", endpoint);
        request.setEntity(RequestConverters.createEntity(previewRequest, RequestConverters.REQUEST_BODY_CONTENT_TYPE));
        return request;
    }

    static Request getDataFrameTransformStats(GetDataFrameTransformStatsRequest statsRequest) {
        String endpoint = new RequestConverters.EndpointBuilder().addPathPartAsIs("_data_frame", "transforms").addPathPart(statsRequest.getId()).addPathPartAsIs("_stats").build();
        Request request = new Request("GET", endpoint);
        if (statsRequest.getPageParams() != null && statsRequest.getPageParams().getFrom() != null) {
            request.addParameter(PageParams.FROM.getPreferredName(), statsRequest.getPageParams().getFrom().toString());
        }
        if (statsRequest.getPageParams() != null && statsRequest.getPageParams().getSize() != null) {
            request.addParameter(PageParams.SIZE.getPreferredName(), statsRequest.getPageParams().getSize().toString());
        }
        if (statsRequest.getAllowNoMatch() != null) {
            request.addParameter("allow_no_match", statsRequest.getAllowNoMatch().toString());
        }
        return request;
    }
}

