/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client;

import java.io.IOException;
import java.util.Collections;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionListener;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.DataFrameRequestConverters;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.RequestOptions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.RestHighLevelClient;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.core.AcknowledgedResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.dataframe.DeleteDataFrameTransformRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.dataframe.GetDataFrameTransformRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.dataframe.GetDataFrameTransformResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.dataframe.GetDataFrameTransformStatsRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.dataframe.GetDataFrameTransformStatsResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.dataframe.PreviewDataFrameTransformRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.dataframe.PreviewDataFrameTransformResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.dataframe.PutDataFrameTransformRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.dataframe.StartDataFrameTransformRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.dataframe.StartDataFrameTransformResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.dataframe.StopDataFrameTransformRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.dataframe.StopDataFrameTransformResponse;

public final class DataFrameClient {
    private final RestHighLevelClient restHighLevelClient;

    DataFrameClient(RestHighLevelClient restHighLevelClient) {
        this.restHighLevelClient = restHighLevelClient;
    }

    public AcknowledgedResponse putDataFrameTransform(PutDataFrameTransformRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, DataFrameRequestConverters::putDataFrameTransform, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public void putDataFrameTransformAsync(PutDataFrameTransformRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, DataFrameRequestConverters::putDataFrameTransform, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetDataFrameTransformStatsResponse getDataFrameTransformStats(GetDataFrameTransformStatsRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, DataFrameRequestConverters::getDataFrameTransformStats, options, GetDataFrameTransformStatsResponse::fromXContent, Collections.emptySet());
    }

    public void getDataFrameTransformStatsAsync(GetDataFrameTransformStatsRequest request, RequestOptions options, ActionListener<GetDataFrameTransformStatsResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, DataFrameRequestConverters::getDataFrameTransformStats, options, GetDataFrameTransformStatsResponse::fromXContent, listener, Collections.emptySet());
    }

    public AcknowledgedResponse deleteDataFrameTransform(DeleteDataFrameTransformRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, DataFrameRequestConverters::deleteDataFrameTransform, options, AcknowledgedResponse::fromXContent, Collections.emptySet());
    }

    public void deleteDataFrameTransformAsync(DeleteDataFrameTransformRequest request, RequestOptions options, ActionListener<AcknowledgedResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, DataFrameRequestConverters::deleteDataFrameTransform, options, AcknowledgedResponse::fromXContent, listener, Collections.emptySet());
    }

    public PreviewDataFrameTransformResponse previewDataFrameTransform(PreviewDataFrameTransformRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, DataFrameRequestConverters::previewDataFrameTransform, options, PreviewDataFrameTransformResponse::fromXContent, Collections.emptySet());
    }

    public void previewDataFrameTransformAsync(PreviewDataFrameTransformRequest request, RequestOptions options, ActionListener<PreviewDataFrameTransformResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, DataFrameRequestConverters::previewDataFrameTransform, options, PreviewDataFrameTransformResponse::fromXContent, listener, Collections.emptySet());
    }

    public StartDataFrameTransformResponse startDataFrameTransform(StartDataFrameTransformRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, DataFrameRequestConverters::startDataFrameTransform, options, StartDataFrameTransformResponse::fromXContent, Collections.emptySet());
    }

    public void startDataFrameTransformAsync(StartDataFrameTransformRequest request, RequestOptions options, ActionListener<StartDataFrameTransformResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, DataFrameRequestConverters::startDataFrameTransform, options, StartDataFrameTransformResponse::fromXContent, listener, Collections.emptySet());
    }

    public StopDataFrameTransformResponse stopDataFrameTransform(StopDataFrameTransformRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, DataFrameRequestConverters::stopDataFrameTransform, options, StopDataFrameTransformResponse::fromXContent, Collections.emptySet());
    }

    public void stopDataFrameTransformAsync(StopDataFrameTransformRequest request, RequestOptions options, ActionListener<StopDataFrameTransformResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, DataFrameRequestConverters::stopDataFrameTransform, options, StopDataFrameTransformResponse::fromXContent, listener, Collections.emptySet());
    }

    public GetDataFrameTransformResponse getDataFrameTransform(GetDataFrameTransformRequest request, RequestOptions options) throws IOException {
        return this.restHighLevelClient.performRequestAndParseEntity(request, DataFrameRequestConverters::getDataFrameTransform, options, GetDataFrameTransformResponse::fromXContent, Collections.emptySet());
    }

    public void getDataFrameTransformAsync(GetDataFrameTransformRequest request, RequestOptions options, ActionListener<GetDataFrameTransformResponse> listener) {
        this.restHighLevelClient.performRequestAsyncAndParseEntity(request, DataFrameRequestConverters::getDataFrameTransform, options, GetDataFrameTransformResponse::fromXContent, listener, Collections.emptySet());
    }
}

