/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ingest;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ElasticsearchException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ingest.WriteableIngestDocument;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.Writeable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ingest.IngestDocument;

public class SimulateProcessorResult
implements Writeable,
ToXContentObject {
    private static final String IGNORED_ERROR_FIELD = "ignored_error";
    private final String processorTag;
    private final WriteableIngestDocument ingestDocument;
    private final Exception failure;
    private static final ConstructingObjectParser<ElasticsearchException, Void> IGNORED_ERROR_PARSER = new ConstructingObjectParser("ignored_error_parser", true, a -> (ElasticsearchException)a[0]);
    public static final ConstructingObjectParser<SimulateProcessorResult, Void> PARSER;

    public SimulateProcessorResult(String processorTag, IngestDocument ingestDocument, Exception failure) {
        this.processorTag = processorTag;
        this.ingestDocument = ingestDocument == null ? null : new WriteableIngestDocument(ingestDocument);
        this.failure = failure;
    }

    public SimulateProcessorResult(String processorTag, IngestDocument ingestDocument) {
        this(processorTag, ingestDocument, null);
    }

    public SimulateProcessorResult(String processorTag, Exception failure) {
        this(processorTag, null, failure);
    }

    SimulateProcessorResult(StreamInput in) throws IOException {
        this.processorTag = in.readString();
        this.ingestDocument = in.readBoolean() ? new WriteableIngestDocument(in) : null;
        this.failure = in.readException();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.processorTag);
        if (this.ingestDocument == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.ingestDocument.writeTo(out);
        }
        out.writeException(this.failure);
    }

    public IngestDocument getIngestDocument() {
        if (this.ingestDocument == null) {
            return null;
        }
        return this.ingestDocument.getIngestDocument();
    }

    public String getProcessorTag() {
        return this.processorTag;
    }

    public Exception getFailure() {
        return this.failure;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.processorTag != null) {
            builder.field("tag", this.processorTag);
        }
        if (this.failure != null && this.ingestDocument != null) {
            builder.startObject(IGNORED_ERROR_FIELD);
            ElasticsearchException.generateFailureXContent(builder, params, this.failure, true);
            builder.endObject();
        } else if (this.failure != null) {
            ElasticsearchException.generateFailureXContent(builder, params, this.failure, true);
        }
        if (this.ingestDocument != null) {
            this.ingestDocument.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }

    public static SimulateProcessorResult fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    static {
        IGNORED_ERROR_PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> ElasticsearchException.fromXContent(p), new ParseField("error", new String[0]));
        PARSER = new ConstructingObjectParser("simulate_processor_result", true, a -> {
            String processorTag = a[0] == null ? null : (String)a[0];
            IngestDocument document = a[1] == null ? null : ((WriteableIngestDocument)a[1]).getIngestDocument();
            ElasticsearchException failure = null;
            if (a[2] != null) {
                failure = (ElasticsearchException)a[2];
            } else if (a[3] != null) {
                failure = (ElasticsearchException)a[3];
            }
            return new SimulateProcessorResult(processorTag, document, failure);
        });
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField("tag", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), WriteableIngestDocument.INGEST_DOC_PARSER, new ParseField("doc", new String[0]));
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), IGNORED_ERROR_PARSER, new ParseField(IGNORED_ERROR_FIELD, new String[0]));
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ElasticsearchException.fromXContent(p), new ParseField("error", new String[0]));
    }
}

