/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ingest;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.bytes.BytesReference;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.StatusToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParserUtils;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ingest.PipelineConfiguration;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.rest.RestStatus;

public class GetPipelineResponse
extends ActionResponse
implements StatusToXContentObject {
    private List<PipelineConfiguration> pipelines;

    public GetPipelineResponse() {
    }

    public GetPipelineResponse(List<PipelineConfiguration> pipelines) {
        this.pipelines = pipelines;
    }

    public List<PipelineConfiguration> pipelines() {
        return Collections.unmodifiableList(this.pipelines);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        int size = in.readVInt();
        this.pipelines = new ArrayList<PipelineConfiguration>(size);
        for (int i = 0; i < size; ++i) {
            this.pipelines.add(PipelineConfiguration.readFrom(in));
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.pipelines.size());
        for (PipelineConfiguration pipeline : this.pipelines) {
            pipeline.writeTo(out);
        }
    }

    public boolean isFound() {
        return !this.pipelines.isEmpty();
    }

    @Override
    public RestStatus status() {
        return this.isFound() ? RestStatus.OK : RestStatus.NOT_FOUND;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        for (PipelineConfiguration pipeline : this.pipelines) {
            builder.field(pipeline.getId(), pipeline.getConfigAsMap());
        }
        builder.endObject();
        return builder;
    }

    public static GetPipelineResponse fromXContent(XContentParser parser) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser::getTokenLocation);
        ArrayList<PipelineConfiguration> pipelines = new ArrayList<PipelineConfiguration>();
        while (parser.nextToken().equals((Object)XContentParser.Token.FIELD_NAME)) {
            String pipelineId = parser.currentName();
            parser.nextToken();
            XContentBuilder contentBuilder = XContentBuilder.builder(parser.contentType().xContent());
            try {
                contentBuilder.generator().copyCurrentStructure(parser);
                PipelineConfiguration pipeline = new PipelineConfiguration(pipelineId, BytesReference.bytes(contentBuilder), contentBuilder.contentType());
                pipelines.add(pipeline);
            }
            finally {
                if (contentBuilder == null) continue;
                contentBuilder.close();
            }
        }
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.END_OBJECT, parser.currentToken(), parser::getTokenLocation);
        return new GetPipelineResponse(pipelines);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof GetPipelineResponse) {
            GetPipelineResponse otherResponse = (GetPipelineResponse)other;
            if (this.pipelines == null) {
                return otherResponse.pipelines == null;
            }
            HashMap<String, PipelineConfiguration> otherPipelineMap = new HashMap<String, PipelineConfiguration>();
            for (PipelineConfiguration pipeline : otherResponse.pipelines) {
                otherPipelineMap.put(pipeline.getId(), pipeline);
            }
            for (PipelineConfiguration pipeline : this.pipelines) {
                PipelineConfiguration otherPipeline;
                if (pipeline.equals(otherPipeline = (PipelineConfiguration)otherPipelineMap.get(pipeline.getId()))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return Strings.toString(this);
    }

    public int hashCode() {
        int result = 1;
        for (PipelineConfiguration pipeline : this.pipelines) {
            result += pipeline == null ? 0 : pipeline.hashCode();
        }
        return result;
    }
}

