/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.get;

import com.carrotsearch.hppc.IntArrayList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.get.GetResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.get.MultiGetResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;

public class MultiGetShardResponse
extends ActionResponse {
    final IntArrayList locations;
    final List<GetResponse> responses;
    final List<MultiGetResponse.Failure> failures;

    MultiGetShardResponse() {
        this.locations = new IntArrayList();
        this.responses = new ArrayList<GetResponse>();
        this.failures = new ArrayList<MultiGetResponse.Failure>();
    }

    MultiGetShardResponse(StreamInput in) throws IOException {
        super(in);
        int size = in.readVInt();
        this.locations = new IntArrayList(size);
        this.responses = new ArrayList<GetResponse>(size);
        this.failures = new ArrayList<MultiGetResponse.Failure>(size);
        for (int i = 0; i < size; ++i) {
            this.locations.add(in.readVInt());
            if (in.readBoolean()) {
                this.responses.add(new GetResponse(in));
            } else {
                this.responses.add(null);
            }
            if (in.readBoolean()) {
                this.failures.add(MultiGetResponse.Failure.readFailure(in));
                continue;
            }
            this.failures.add(null);
        }
    }

    public void add(int location, GetResponse response) {
        this.locations.add(location);
        this.responses.add(response);
        this.failures.add(null);
    }

    public void add(int location, MultiGetResponse.Failure failure) {
        this.locations.add(location);
        this.responses.add(null);
        this.failures.add(failure);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        throw new UnsupportedOperationException("usage of Streamable is to be replaced by Writeable");
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.locations.size());
        for (int i = 0; i < this.locations.size(); ++i) {
            out.writeVInt(this.locations.get(i));
            if (this.responses.get(i) == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                this.responses.get(i).writeTo(out);
            }
            if (this.failures.get(i) == null) {
                out.writeBoolean(false);
                continue;
            }
            out.writeBoolean(true);
            this.failures.get(i).writeTo(out);
        }
    }
}

