/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.get;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ElasticsearchException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.get.GetResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.get.MultiGetItemResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.Streamable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.get.GetResult;

public class MultiGetResponse
extends ActionResponse
implements Iterable<MultiGetItemResponse>,
ToXContentObject {
    private static final ParseField INDEX = new ParseField("_index", new String[0]);
    private static final ParseField TYPE = new ParseField("_type", new String[0]);
    private static final ParseField ID = new ParseField("_id", new String[0]);
    private static final ParseField ERROR = new ParseField("error", new String[0]);
    private static final ParseField DOCS = new ParseField("docs", new String[0]);
    private MultiGetItemResponse[] responses;

    MultiGetResponse() {
    }

    public MultiGetResponse(MultiGetItemResponse[] responses) {
        this.responses = responses;
    }

    public MultiGetItemResponse[] getResponses() {
        return this.responses;
    }

    @Override
    public Iterator<MultiGetItemResponse> iterator() {
        return Arrays.stream(this.responses).iterator();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startArray(DOCS.getPreferredName());
        for (MultiGetItemResponse response : this.responses) {
            if (response.isFailed()) {
                Failure failure = response.getFailure();
                failure.toXContent(builder, params);
                continue;
            }
            GetResponse getResponse = response.getResponse();
            getResponse.toXContent(builder, params);
        }
        builder.endArray();
        builder.endObject();
        return builder;
    }

    public static MultiGetResponse fromXContent(XContentParser parser) throws IOException {
        String currentFieldName = null;
        ArrayList<MultiGetItemResponse> items = new ArrayList<MultiGetItemResponse>();
        XContentParser.Token token = parser.nextToken();
        while (token != XContentParser.Token.END_OBJECT) {
            switch (token) {
                case FIELD_NAME: {
                    currentFieldName = parser.currentName();
                    break;
                }
                case START_ARRAY: {
                    if (!DOCS.getPreferredName().equals(currentFieldName)) break;
                    token = parser.nextToken();
                    while (token != XContentParser.Token.END_ARRAY) {
                        if (token == XContentParser.Token.START_OBJECT) {
                            items.add(MultiGetResponse.parseItem(parser));
                        }
                        token = parser.nextToken();
                    }
                    break;
                }
            }
            token = parser.nextToken();
        }
        return new MultiGetResponse(items.toArray(new MultiGetItemResponse[0]));
    }

    private static MultiGetItemResponse parseItem(XContentParser parser) throws IOException {
        String currentFieldName = null;
        String index = null;
        String type = null;
        String id = null;
        ElasticsearchException exception = null;
        GetResult getResult = null;
        XContentParser.Token token = parser.nextToken();
        while (token != XContentParser.Token.END_OBJECT) {
            switch (token) {
                case FIELD_NAME: {
                    currentFieldName = parser.currentName();
                    if (INDEX.match(currentFieldName, parser.getDeprecationHandler()) || TYPE.match(currentFieldName, parser.getDeprecationHandler()) || ID.match(currentFieldName, parser.getDeprecationHandler()) || ERROR.match(currentFieldName, parser.getDeprecationHandler())) break;
                    getResult = GetResult.fromXContentEmbedded(parser, index, type, id);
                    break;
                }
                case VALUE_STRING: {
                    if (INDEX.match(currentFieldName, parser.getDeprecationHandler())) {
                        index = parser.text();
                        break;
                    }
                    if (TYPE.match(currentFieldName, parser.getDeprecationHandler())) {
                        type = parser.text();
                        break;
                    }
                    if (!ID.match(currentFieldName, parser.getDeprecationHandler())) break;
                    id = parser.text();
                    break;
                }
                case START_OBJECT: {
                    if (!ERROR.match(currentFieldName, parser.getDeprecationHandler())) break;
                    exception = ElasticsearchException.fromXContent(parser);
                    break;
                }
            }
            if (getResult != null) break;
            token = parser.nextToken();
        }
        if (exception != null) {
            return new MultiGetItemResponse(null, new Failure(index, type, id, exception));
        }
        GetResponse getResponse = new GetResponse(getResult);
        return new MultiGetItemResponse(getResponse, null);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.responses = new MultiGetItemResponse[in.readVInt()];
        for (int i = 0; i < this.responses.length; ++i) {
            this.responses[i] = MultiGetItemResponse.readItemResponse(in);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVInt(this.responses.length);
        for (MultiGetItemResponse response : this.responses) {
            response.writeTo(out);
        }
    }

    public static class Failure
    implements Streamable,
    ToXContentObject {
        private String index;
        private String type;
        private String id;
        private Exception exception;

        Failure() {
        }

        public Failure(String index, String type, String id, Exception exception) {
            this.index = index;
            this.type = type;
            this.id = id;
            this.exception = exception;
        }

        public String getIndex() {
            return this.index;
        }

        public String getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }

        public String getMessage() {
            return this.exception != null ? this.exception.getMessage() : null;
        }

        public static Failure readFailure(StreamInput in) throws IOException {
            Failure failure = new Failure();
            failure.readFrom(in);
            return failure;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.index = in.readString();
            this.type = in.readOptionalString();
            this.id = in.readString();
            this.exception = in.readException();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.index);
            out.writeOptionalString(this.type);
            out.writeString(this.id);
            out.writeException(this.exception);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(INDEX.getPreferredName(), this.index);
            builder.field(TYPE.getPreferredName(), this.type);
            builder.field(ID.getPreferredName(), this.id);
            ElasticsearchException.generateFailureXContent(builder, params, this.exception, true);
            builder.endObject();
            return builder;
        }

        public Exception getFailure() {
            return this.exception;
        }
    }
}

